.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdSetPickPathOrder 3D "Dore"
.SH NAME
DdSetPickPathOrder \- Set the order of pick path elements returned to \f2DdPickObjs\fP
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdSetPickPathOrder(device, pathorder)
DtObject device;
DtPickPathOrder pathorder;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDSPPO(DEVICE, PTHORD)
INTEGER*4 DEVICE
INTEGER*4 PTHORD
.in -.5i
.fi
.SH DESCRIPTION
.IX DDSPPO
.IX DdSetPickPathOrder
.I DdSetPickPathOrder
determines the order of the returned pick path elements when using
\f2DdPickObjs\fP <\f2DDPO\fP> on the given device \f2device\fP.
See \f2DdSetPickCallback\fP for a description of pick paths.
.PP
The valid values for \f2pathorder\fP are:
.IP "\f2DcTopFirst\fP <\f2DCTOPF\fP>"
The pick path starts with the group at the root
of the display tree containing the picked primitive
object and ends with the picked primitive object itself.
.IP "\f2DcBottomFirst\fP <\f2DCBOTF\fP>"
The pick path starts with the picked primitive
itself and ends with the group at the root of the
display tree containing the picked primitive object.
.PP
Note that the value of the pick path order affects only the order of pick
path elements in paths returned from \f2DdPickObjs\fP <\f2DDPO\fP>
and does NOT affect the order of elements as seen by the pick callback
functions (see \f2DdSetPickCallback\fP).
.SH ERRORS
.I DdSetPickPathOrder
will fail if passed an invalid device handle.
.TP 15
[WARNING - invalid device handle]
.PP
\f2DdSetPickCallback\fP will fail if passed an invalid path order.
.TP 15
[WARNING - invalid pick path order]
.SH DEFAULTS
The default pick path order is \f2DcTopFirst\fP <\f2DCTOPF\fP>.
.SH "SEE ALSO"
.na
.nh
DdInqPickPathOrder(3D), DdPickObjs(3D), DdSetPickCallback(3D)
.ad
.hy
