/* terminal
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 * The TERMINAL module serves as one of the main interfaces to the
 * operating system, the other interface being the NETWORK module.
 * This module provides primitives for outputting text to the screen
 * and reading characters from the keyboard.  We assume that
 * the screen has at least 24 lines and 80 columns, that the cursor
 * is addressable, and that it is possible to check in advance whether
 * or not a character is available from the keyboard.
 */

#ifdef _TERMINAL_

  int bell_is_on = 1; /* A boolean variable indicating that the bell
			 should be rung when the ring_bell () procedure
			 is called. */

#else

  extern int bell_is_on;

#endif

extern int terminal_lines, terminal_cols;
  /* The number of lines and columns in the terminal display. */
 
extern void Initialize_Terminal ();
/* To be called once at the beginning of the program. */

extern void Reinitialize_Terminal ();
/* Reconstructs the terminal state.  To be used after a SIGWINCH has
   been detected. */
 
extern void print ();
/* void print (int row, int col, char *message); */
/* (1,1) specifies the upper left corner of the screen. */
 
extern int char_avail ();
/* int char_avail (void); */
/* Returns TRUE if a character is available from the keyboard. */
 
extern int input_char ();
/* int input_char (void); */
/* Returns the next input character from the keyboard. */
 
extern void set_cursor ();
/* void set_cursor (int row, int col); */
/* Places the cursor at the specified (row, col). */

extern void restore_cursor ();
/* void restore_cursor (void); */
/* Restores the cursor to its location as of the last call to set_cursor. */
 
extern void clear_screen ();
/* void clear_screen (void); */
/* Clears the screen and places the cursor in the upper left corner. */
 
extern void ring_bell ();
/* void ring_bell (void); */
/* Rings the terminal's bell */

extern void Reset_Terminal ();
/* void Reset_Terminal (void); */
/* To be called at the end of the program to reset the terminal to its
   initial operating mode. */
