/* terminal
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 */
 
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <curses.h>

#ifdef AIX
#include <sys/select.h>
#ifndef TIOCGWINSZ
#include <termios.h>
#endif
#endif

#ifdef HPUX
#ifndef TIOCGWINSZ
#include <sys/termio.h>
#endif
#endif

#ifdef VMS
#include descrip
#include iodef
#endif

#ifdef SCO
#include <sys/stream.h>
#include <sys/ptem.h>
#endif

#ifdef ultrix
#define cbreak crmode
#endif

#ifdef DYNIX
#define cbreak crmode
#endif

#ifdef CONVEX
#define cbreak crmode
#endif

#define _TERMINAL_
#include "terminal.h"
#include "fds.h"

#ifdef GCC
extern printf ();
#endif

#if !defined(sgi) && !defined(__sgi)
/* extern int exit (); */
extern int stty ();
extern int select ();
extern void bzero ();
extern int read ();

extern int endwin ();
extern int wmove ();
extern int waddstr ();
extern int wrefresh ();
extern int wclear ();
#endif

int cursor_x, cursor_y;   /* The current position of the input cursor. */
int terminal_lines, terminal_cols; 
  /* The size of the terminal screen. */
 
#ifdef VMS
$DESCRIPTOR(device, "TT:");
char ichar;
int chan,iefn,wefn;
int wtime[2]= {-1*5000000,-1};
#endif

void Initialize_Terminal ()
/* To be called once at the beginning of the program. */
{
#ifdef TIOCGWINSZ
  struct winsize size;
#endif

/*
#ifdef SUNOS
        newterm (getenv("TERM"), stdout, stdin);
#else
	initscr ();
#endif
*/


#ifdef TIOCGWINSZ
  if (ioctl(0, TIOCGWINSZ, &size) < 0) {
    terminal_lines = 24; 
    terminal_cols = 80;
  } else {
    terminal_lines = size.ws_row;
    if (terminal_lines == 0) terminal_lines = 24;
    terminal_cols = size.ws_col;
    if (terminal_cols == 0) terminal_cols = 80;
  }
#else
  terminal_lines = 24;
  terminal_cols  = 80;
#endif

#ifndef DEBUG
  if ((terminal_lines < 24) || (terminal_cols < 80)) {
    printf ("ERROR! The terminal window is too small for OKbridge.\n");
    printf ("OKbridge requires at least 24 lines and 80 columns,\n");
    printf ("but this terminal appears to have %d lines and %d columns.\n",
	    terminal_lines, terminal_cols);
    exit (1);
  }
#endif

  /* Based on a suggestion of Jon Ferro (jf41+@andrew.cmu.edu) */

#ifndef VMS
  LINES = terminal_lines;
  COLS = terminal_cols;
#endif

  initscr ();

#ifdef VMS
  sys$assign (&device, &chan, 0, 0);
  crmode ();
  lib$get_ef(&wefn);
  lib$get_ef(&iefn);
  sys$qio(iefn, chan, IO$_READVBLK|IO$M_NOFILTR|IO$M_NOECHO,
		      0, 0, 0, &ichar, 1, 0, 0, 0, 0);
#else
  cbreak ();
#endif

  noecho ();
  nonl ();
}
 

void Reinitialize_Terminal ()
/* Reconstructs the terminal state.  To be used after a SIGWINCH has
   been detected. */
{
#ifdef SUNOS
  endwin();
  Initialize_Terminal ();
#endif
 ;
}
 
void print (row, col, message)
	int row, col; char *message;
/* (1,1) specifies the upper left corner of the screen. */
{
	mvaddstr (row-1, col-1, message);
}

void restore_cursor ()
{
  move (cursor_y, cursor_x);
  refresh ();
}

int char_avail ()
/* Returns TRUE if a character is available from the keyboard. */
{
	struct fd_set wait_set;
	struct timeval tm;

	restore_cursor ();
#ifndef VMS
	FD_ZERO (&wait_set);
	FD_SET (fileno(stdin), &wait_set);
	tm.tv_sec = tm.tv_usec = 0;
        select (FD_SETSIZE, &wait_set, NULL, NULL, &tm);
        return (FD_ISSET(fileno(stdin), &wait_set));
#else
	return (check_typeahead());
#endif
}

#ifdef VMS
void waitfor_keyboard()
{
	sys$setimr(wefn,&wtime,0,0,0);
	sys$wflor(iefn,(1 << (iefn % 32)) | (1 << (wefn % 32)) );
	sys$cantim(wefn,0);
}

int check_typeahead()
{
	int state;
	sys$readef(iefn,&state);
        return ((1 << (iefn % 32)) & state);
}
#endif
 
int input_char ()
/* Returns the next input character from the keyboard. */
{
	int log;
	char chbuf[2];
 
	restore_cursor ();
#ifndef VMS
	log = 0;
	while (log < 1) {
	  log = read (0, chbuf, 1);
	}
#else
        chbuf[0] = ichar;
	if (chbuf[0] == 10) chbuf[0] = 13;
        sys$qio(iefn, chan, IO$_READVBLK|IO$M_NOFILTR|IO$M_NOECHO,
		      0, 0, 0, &ichar, 1, 0, 0, 0, 0);
#endif

	return (chbuf[0]);
}
 
void set_cursor (row, col)
	int row, col;
/* Places the cursor at the specified (row, col). */
{
        cursor_x = col-1;
	cursor_y = row-1;
	restore_cursor ();
}
 
void clear_screen ()
{
  clear ();
  refresh ();
}
 
void ring_bell ()
/* void ring_bell (void); */
/* Rings the terminal's bell */
{
  if (!bell_is_on)
    return;

#ifdef SUNOS
        flash ();
	beep ();
#else
        putchar ('\007');
        putchar ('\007');
#endif
	restore_cursor ();
}

void Reset_Terminal ()
/* To be called at the end of the program to reset the terminal to its
   initial operating mode. */
{
	clear_screen ();
#ifdef VMS
	sys$dassgn (chan);
#endif
	endwin ();
}
 


