/* state.h -- global data values.
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 * This file contains the definitions of all of the global variables.
 * These variables represent the state of the current game.  It seems
 * to be more convenient to make them global variables than to store
 * them locally and pass them as parameters to various procedures.
 *
 * The definition _BRIDGE_ is used to distinguish the external
 * references to these variables from the actual definitions.  The module
 * which defines these variables should give a definition to _BRIDGE_
 * before including this file.
 */

#ifndef TYPES_INCLUDED
#include "types.h"
#endif

#ifndef NETWORK_INCLUDED
#include "network.h"
#endif

#ifdef _BRIDGE_
 
	/* Variables used to control the behavior of the local copy
	   of the program: */

        int prompt_dummy = 1;    /* true if the dummy should be prompted
				    after each play. */

        int default_plays=1;     /* true if default plays are allowed. */

        int autopass_mode = 1;   /* true if the moderator should automatically
				    generate PASS bids for absent players
				    during PRACTICE play. */

        int local_player;        /* the seat assigned to the local player. */

        char *local_player_name; /* the nickname of the local player. */
        int   local_player_id = -1;/* the id assigned by the GPS to the
				    local player. */
        char *local_player_pw;   /* password for the local player. */
        char *local_player_full_name = NULL;
          /* The name of the local player as specified with the FULLNAME
	     field in the .okbridgerc file. */
        char *local_player_email = NULL;
          /* The email address of the local player as specified with the
             EMAIL field in the .okbridgerc file. */
        Score local_player_mp_total;
          /* The total MP score for the local player. */
        Score local_player_imp_total;
          /* The total IMP score for the local player. */
        Score local_player_total_score;
          /* The total rubber or duplicate score for the local player. */
        Score local_player_score;
          /* The score record for the local player on the last hand. */

        char *local_cc;
          /* The convention card of the local player as specified with the
             CC field in the .okbridgerc file. */
        char *conventions[2] = {NULL, NULL};
          /* The convention cards of NS and EW, respectively. */
 
	/* Information regarding the current hand: */
        struct Table_struct *Local_table;
          /* The table where we are sitting. */
        struct Board_struct *Local_board;
          /* The current board being played. */
        struct Play_record_struct *Local_play;
          /* The record of the plays which have been made in the current
	     board. */

        struct Board_struct *Prev_board = NULL;
          /* The last board which was played. */
        struct Play_record_struct *Prev_play = NULL;
          /* And the associated play record. */

        /* Information about the hands which are visible: */
        int spectator_mode;     /* true if the observer has been shown
                                   any hands. */
        int revealed_bidder;    /* the bidder which is currently revealed to
                                   the spectator. */
        int revealed_hands[4];  /* the hands which have been revealed to
				   the player. */

        int scoring_mode = MP_SCORING;       
                                /* the scoring mode which will be used
				   in shuffling new boards. */

	int hands_played;	/* the number of hands that have been
				   played so far. */
 
        /* Additional variables used for maintaining global state: */
        int claim_responses,    /* number of responses received so far
				   to a claim request. */
            claim_accepted;     /* true if neither defender has rejected
				   the claim. */

        /* Information pertaining to email duplicate play: */
        char *email_filename = NULL;   
                                /* the filename where we will save the
				   hands that have been played. */

        int replay_mode = 0;    /* TRUE if we should automatically save
				   the hands back to the email_file after
				   we have finished playing them. */

        int gps_duplicate_mode = 0;  
                                /* TRUE if we are playing GPS duplicate. */

#else
 
        extern int prompt_dummy;
        extern int default_plays;
        extern int autopass_mode;
        extern int local_player;
        extern char *local_player_name;
        extern int   local_player_id;
        extern char *local_player_pw;
        extern char *local_player_full_name;
        extern char *local_player_email;
        extern Score local_player_mp_total;
        extern Score local_player_imp_total;
        extern Score local_player_total_score;
        extern Score local_player_score;

        extern char *local_cc;
        extern char *conventions[];
 
	/* Information regarding the current hand: */
        extern struct Table_struct *Local_table;
        extern struct Board_struct *Local_board;
        extern struct Play_record_struct *Local_play;

        extern struct Board_struct *Prev_board;
        extern struct Play_record_struct *Prev_play;

        /* Information about the spectator: */
        extern int spectator_mode, 
                   revealed_bidder,
                   revealed_hands[4];

	/* Information regarding the current trick being played: */
/*	extern int  leader,
		    no_plays,
		    plays [];
*/
 
	/* Scoring information: */
	extern int  scoring_mode,
		    hands_played;
 
        /* Additional variables used for maintaining global state: */
        extern int  claim_responses, claim_accepted;

        /* Information pertaining to email duplicate play: */
        extern char *email_filename;
        extern int  replay_mode;
        extern int  gps_duplicate_mode;

#endif
