/* rc.c
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "types.h"
#include "state.h"
#include "parser.h"
#include "input.h"

#ifdef GCC
extern fprintf (), strcasecmp (), fclose ();
#endif

extern char *getenv ();
extern char *strdup ();
extern void exit ();
extern char *Get_CC_Value ();
extern int  Define_CC ();
extern void Command_Initializing();
extern void Write_Command_Variables();
extern void Write_Control_Keys();

#ifndef index
extern char *index ();
#endif

extern int String_is_alphameric ();

#define	MAX_LENGTH	100


static char line_buffer [MAX_LENGTH];
static int  line_no;
static FILE *init_file;
static int  error_flag;

extern char *sys_errlist[];

void Field_Error (error_msg)
	char *error_msg;
/* Prints out the current line from the field file along with an error
   message.
*/
{
        int i;

	fprintf (stderr, "LINE %2d: %s\n", line_no, line_buffer);
	for (i = 0; i < Parser_Error_Location + 9; i++)
	  fprintf (stderr, " ");
	fprintf (stderr, "^ ERROR\n");
	fprintf (stderr, "ERROR:  %s\n", error_msg);
	error_flag = 1;
}

static int Read_Field_Line ()
/* Reads a line from initialization file init_file and copies it into
   line_buffer.  Returns 1 if data is returned, or 0 if the end of file
   is reached.  Skips comment lines.  Strips trailing blanks from the
   end of the line.
*/
{
	int ch;
	int line_length;

	do {
	        line_length = 0;
		ch = getc (init_file);
		while ((ch != EOF) && (ch != '\n')) {
			if (line_length < MAX_LENGTH)
				line_buffer [line_length++] = ch;
			ch = getc(init_file);
		}
		if (ch == EOF)
			return (0);
		line_no++;
		while (line_buffer[line_length-1] == ' ')
			line_length--;
	} while ((line_length == 0) || (line_buffer[0] == '#'));

	line_buffer[line_length] = '\0';
	return (1);
}

int Open_initialization_file (basefilename, mode)
/* Opens the basefilename file in the home directory, and returns
   whether or not the open was successful. 
*/
     char *basefilename, *mode;
{
  char *home_dir, filename_buf[128];
  
  init_file = fopen (basefilename, "r");
  if (init_file != NULL) {
    if (!strcmp(mode, "r"))
      return (1);
    fclose (init_file);
    init_file = fopen (basefilename, mode);
    if (init_file != NULL)
      return (1);
  }
  
  home_dir = getenv ("HOME");
  
  if (home_dir != NULL) {
    sprintf (filename_buf, "%s/%s", home_dir, basefilename);
    init_file = fopen (filename_buf, mode);
  }
  
  return (init_file != NULL);
}


void Read_Initialization_File (basefilename)
     char *basefilename;
{

  if (!Open_initialization_file(basefilename, "r"))
    return;
  
  error_flag = 0;
  line_no = 0;
  Command_Initializing(1);
  while (Read_Field_Line()) {
    if(Parse_Initialization_Command(line_buffer))
      Field_Error (Parser_Error_Buf);
  }
  Command_Initializing(0);
  
  fclose (init_file);
  
  if (error_flag) {
    fprintf (stderr, "\nErrors in %s %s -- %s\n", basefilename,
	     "initialization file", "Program terminating");
    exit (1);
  }
  
}

void Write_Initialization_File (basefilename)
     char *basefilename;
{

	if (!Open_initialization_file(basefilename,"w"))
	  return;

	Write_Command_Variables (init_file);
	Write_Key_Mappings (init_file);

	fclose (init_file);

}
