/* shuffle.c -- generate shuffles for use in email duplicate play.
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 * Format of command:
 *   
 *   okshuffle [nboards] [-n board-names] [-r] [-d] [-i] [-m]
 *
 * where
 *   nboards 
 *     is the number of boards to generate.  If omitted, nboards
 *     defaults to 4.
 *
 *   -n board-names
 *     a brief (max 10 chars) name which will be used to identify the
 *     boards.  If this is omitted, then a name is invented which is based
 *     on the current date.
 *
 *   -r, -d, -i, -m
 *     specifies the scoring mode to be respectively rubber, duplicate,
 *     imp or mp.  The default scoring mode is imp.
 *
 * Writes the encoded boards to standard output.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <string.h>

#define _BRIDGE_

#include "types.h"
#include "boards.h"
#include "state.h"

#ifdef GCC
extern fprintf ();
extern time_t time ();
#endif

extern char *malloc ();
extern char *strdup ();

extern int errno;
extern char *sys_errlist[];
extern void exit ();
extern int  atoi ();
extern void srand ();

static void parameter_error (msg)
     char *msg;
{
  fprintf (stderr, "shuffle: error in parameters: %s\n", msg);
  fprintf (stderr, "shuffle: usage: shuffle [nboards] [-m initial_message]\n");
  exit (1);
}

void main (argc, argv)
     int argc; char *argv[];
{
  int i, nboards, know_nboards, print_date;
  char *board_name;
  char error_buf[80];
/*  time_t time_value; */
  Board *b;

  nboards = 4;
  know_nboards = 0;
  print_date = 0;
  scoring_mode = IMP_SCORING;
  board_name = NULL;

  for (i = 1; i < argc; i++) {
    if (!strcmp(argv[i], "-d"))
      scoring_mode = DUPLICATE_SCORING;
    else if (!strcmp(argv[i], "-i"))
      scoring_mode = IMP_SCORING;
    else if (!strcmp(argv[i], "-m"))
      scoring_mode = MP_SCORING;
    else if (!strcmp(argv[i], "-r"))
      scoring_mode = RUBBER_SCORING;
    else if (!strcmp(argv[i], "-n")) {
      i++;
      if (i < argc)
	board_name = strdup (argv[i]);
      else
	parameter_error ("board_name missing");
    } else if (!know_nboards) {
      nboards = atoi (argv[i]);
      know_nboards = 1;
      if (nboards <= 0) {
	sprintf (error_buf, "expected integer nboards, but got %s", argv[i]);
	parameter_error (error_buf);
      }
    } else
      parameter_error ("too many parameters");
  }


/*
  if (print_date) {
    time (&time_value);
    sprintf (date_buffer, "THIS HAND WAS SHUFFLED ON %s", ctime(&time_value));
    if (date_buffer[strlen(date_buffer)-1] == '\n')
      date_buffer[strlen(date_buffer)-1] = '\0';
  }
*/

  b = NULL;
  for (i = 0; i < nboards; i++) {
    if (scoring_mode == RUBBER_SCORING)
      b = Generate_Random_Rubber_Board (b, NULL);
    else
      b = Generate_Random_Match_Board (scoring_mode, b);
    if (board_name != NULL)
      b->source = strdup (board_name);
    Record_Played_Board (b);
  }

  Write_Email_Duplicate_File (stdout);
}
