.\"
.\" Adapted from README.Playing -- how to operate the okbridge program
.\" Matthew Clegg.  September 1990.  Updated May 1991, March 1992, May 1992.
.\"
.TH "OKBRIDGE" 6 "4 Aug 1992"
.SH NAME
okbridge \- multi-player networked bridge game
.SH SYNPOSIS
.na
.in +9n
.ti -9n
okbridge
.I position name server
[\fB\-dimR\fP]
[\fB\-p\fP\ \fIportno\fP]
[\fB\-G\fP]
[\fB\-r\fP\ \fIreplay\-file\fP]
[\fB\-b\fP\ \fIboards\-file\fP]
[\fB\-L\fP\ \fIlogfile\fP]
[\fB\-pn, -pe, -ps, -pw\fP]
[\fB\-n\fP\ \fIplayer-name\fP]
[\fB\-s\fP\ \fIserver-name\fP]
.in -9n
.ad
.SH OPTIONS
.IP "\fIposition\fP"
A position-dependent parameter which specifies the seat 
(north, south, east or west) which the local player wishes to occupy.
The \fIposition\fP should be specified as the first letter of the
name of the seat (n, s, e or w).
.IP "\fIname\fP"
A position-dependent parameter which specifies the name by which 
the local player would like to be identified
to other bridge players.  This name may be up to eight characters long.
If it is omitted, then the login name is used.
.IP "\fIserver\fP"
A position-dependent parameter which specifies the Internet name 
or number where the server will be running.
If the local player wishes to be the server, then the word "me" may be
used as the server name.
.IP "\fB-d\fP, \fB-i\fP, \fB-m\fP, \fB-R\fP"
Indicate that the playing and scoring conventions respectively for
Duplicate, IMP, Match point or Rubber bridge should be used.  
These parameters are only relevant for the player
who is the server.  In other words, the server makes the decision
for everyone about the scoring convention that will be used.
If this parameter is omitted, then the playing and scoring conventions
will default to those of rubber bridge.  The -R parameter is suppplied
for the sake of overriding any default which may appear in the .okbridgerc 
file.
.IP "\fB-p\fP \fIportno\fP"
Specifies the port number which will be used for establishing the
network connections.  It is only in unusual circumstances that this
parameter need be specified.
.IP "\fB-G\fP"
Specifies that the Global Player Service (GPS) should \fInot\fP be contacted.
See below for a description of the Global Player Service.
.IP "\fB-b\fP \fIboards-file\fP"
Specifies that the file \fIboards-file\fP contains a sequence of
duplicate deals which should be played.  This is equivalent to the LOAD 
command in the .okbridgerc file.  See the description of email duplicate
bridge below.
.IP "\fB-L\fP \fIlogfile\fP"
Specifies the name of the file to which the results of play will be
written.  This is equivalent to the LOG command in the .okbridgerc file.
.IP "\fB-z#\fP \fI[zhang-logfile]\fP"
Specifes an alternate log file which will be recorded in the format
developed by Shangyou Zhang.  The character '#' should be replaced by
a table number.  If the name of the file is omitted, then the name
"okb_#_rec" will be used.
.IP "\fB-pn, -pe, -ps, -pw\fP"
A position-independent parameter for specifying the player's position.
.IP "\fB-n\fP \fIplayer-name\fP"
A position-independent parameter for specifying the player's name.
.IP "\fB-s\fP \fIserver-name\fP"
A position-independent parameter for specifying the location of
the server.  If the server-name is given as "me", then the local
player will be the server.
.SH "PLAYING"
.PP
.SH "The Okbridge Milieu"
.PP
Okbridge allows people to play bridge together using the Internet.
It is a distributed program, which means that each player runs a
separate instance of the program, and these instances communicate
with each other through the Internet to cooperatively provide the
illusion of a bridge game.  
.PP
At any given moment, there may be many bridge tables currently open,
with players at these tables playing bridge together.  Each table
allows four people to play bridge together.  There may be a number of
additional people at a table who are observing the play.  Each table
has a host, who is called the \fIserver\fP.  While the server is hosting the
table, the table is said to be \fIopen\fP.  The server can be either
observing or playing.  A player who is not a server is said to
be a \fIclient\fP.
.PP
A list of currently open bridge tables is maintained in a worldwide
database called the Global Player Service (GPS).  When a new player
starts the okbridge program, the GPS is contacted and the list of
currently open bridge tables is displayed.  The player then has a
choice of either joining one of the currently open tables or hosting a
new table.
.PP
When four players have joined a table, they must choose \fIseats\fP before
they can begin play.  The seats are labeled north, south, east and
west, and a player chooses a seat by using one of the commands:
/NORTH, /SOUTH, /EAST or /WEST (see the list of commands below).
Also, the server may choose one of several scoring modes (see below).
Play can begin once the seats are all occupied.
.PP
In addition to playing bridge together, the players at a table may
talk with each other and find out a limited amount of information
about each other (see the /WHO and /WHOIS commands below).  There are
a number of options for controlling the format of the display and
input, see e.g., the /BELL, /DEFAULT, /FORMAL, /PROMPT, and /SPEC
commands.  Okbridge provides for very elementary convention
cards (see the /CC and /CCDEF commands below), and it provides some
support for duplicate play (also discussed below).

.SH "Invoking the okbridge Program"
Usually, it is sufficient to start okbridge simply
by typing one of the following two commands:
.IP okbridge
.IP "okbridge -n your-name"
.PP
This will contact the Global Player Service for a list of the currently
playing tables.  The /JOIN (or /CONNECT) command can the be used to join
an open table, or the /SERVE command can be used to begin serving a
new table.
.PP
However, if a game has been arranged in advance, then it is possible
to specify explicitly the name of the server and the seat arrangement.
Suppose that the names of the players are Alex,
Bob, Cathy and Dot.  Alex and Cathy will be one team, while Bob and Dot
will be the other.  They decide that Alex will be north, and Bob will be
east.  Further, they decide that Bob will be the server.  Here is a
list of the commands that each might use to invoke the okbridge program
on their respective (hypothetical) machines:

.nf
.na
 Name    Position  Machine         Command to invoke okbridge
 ----    --------  -------         --------------------------
 Alex    north     a.alaska.edu    okbridge n Alex b.berkeley.edu
 Bob     east      b.berkeley.edu  okbridge e Bob me
 Cathy   south     c.florida.edu   okbridge s Cathy b.berkeley.edu
 Dot     west      d.maine.edu     okbridge w Dot b.berkeley.edu
.ad
.fi

The server (in this case, Bob) should initiate his copy of the program
first.  When a client starts her copy of the program, an initial
display will be presented and the program will attempt to establish a
connection to the server.  During this time, the keyboard will be
unresponsive.  If the client is unable to establish the connection
within 15-30 seconds, then it will give up and display an error
message.  After the connection is established, the program will enter
a talk mode where messages can be exchanged with the other players.
.PP
When four people have joined a table, they must choose seats.
After this seats have been chosen, the server deals the first hand.
Each player's screen will be
redrawn, showing his or her cards.  The program prompts each player
for bids and broadcasts the bids to the other players.  After the
bidding is complete, playing mode is entered.  The screen is redrawn
in preparation for play.  Again, the program prompts each player for
plays and broadcasts the plays to the others.  After the playing is
complete, a review of the hand is presented to all of the players and
the scores are updated.  During this time, the players may freely
discuss the hand.  Pressing RETURN twice in succession proceeds to the
next hand.  The program continues in this cycle indefinitely until a
player leaves or until the server gives instructions which alter the
behavior of the program.
.PP
Other clients may join the table at any time.  A client who joins
while a hand is in progress will be able to observe the play.  Thus,
the client is said to be an \fIobserver\fP.  The observer may choose
to see the cards of the players by becoming a \fIspectator\fP (see the
/SPEC command below).  Spectators are not allowed to talk to the
players, though.  If one of the players vacates his or her position,
then an observer may take the position.

.SH "The Display and Entering Input"
.PP
Here we give an example of the screen display during bidding.  The numbers
in the left column do not actually appear on the screen -- they are given
for reference purposes only.

.nf
.na
   =======================================================================
 1 OKBRIDGE 1.8A  OBSERVER                                     N-S     E-W
 2 Dec20.1354I NO 1984            Worf  1 1H           TRICKS    0       0
 3                                                     VUL      NO      NO
 4 DEALER: seligman                                    TOTAL   1.5    -1.5
 5                                                     IMP     6.2    -6.2
 6                            ------------------
 7                  seligman  |       1H       |  njt
 8                     1 1D   |                |  1 2C
 9                            |             2C |
10                            |                |
11                            |                |
12                            ------------------
13
14                                 *marek
15
16 BID                                                               3:19
17 TALK                                                              0:00
18
19 -------------------------+--------------------------------------+-----
20 |NETWORK- seligman HAS JOINED THE GAME AS WEST.                      |
21 |N-S CC: 5cm 1nt16-8 stm jxf ger blwd unuNt/MIcQ -x2s 2dfstm wek2    |
22 |E-W CC: prec                                                        |
23 |seligman: Hi!                                                       |
24 |clegg: hi!                                                          |
.ad
.fi

The top line displays the version of the program, in this case 
OKBRIDGE 1.8A.  The word OBSERVER following the version indicates
that the local player is sitting as an observer.
In the upper right corner of the screen (lines 1-6), the scores are
displayed.  The number of tricks taken by each side is displayed on
line 2.  The vulnerabilities are displayed on line 3.  And the scores
are displayed on lines 4 and 5.  We will have more to say about the
scoring below.
.PP
In the center of the screen is the table.  South (Tom) is at
the bottom, west at the left, north at the top and east at the right.
The most recent few bids are displayed on the table, while the entire
past history of each player's bidding is displayed by his or her name.
.PP
The local player types input to the program on lines 16 and 17.
The word 'BID' at the beginning of line 16 indicates that anything
typed on this line will be interpreted as a bid.  The word 'TALK'
at the beginning of line 17 indicates that anything typed on this
line will be sent as a message to all of the other players.
The local player can switch between the two lines by using the
tab key.
.PP
At the right edge of lines 16 and 17 are two timers.  The upper timer
records the total amount of elapsed time during the current hand,
while the lower timer records the amount of time spent waiting for
the local player to enter bids and plays.
.PP
Lines 20 through 24 display messages from the program and from other
players.  Each message is of the form `source: text', where `source'
identifies the origin of the message, usually the name of one of the
other players.  Sometimes the source will be MODERATOR, indicating a
message about the internal state of the program.  At other times,
the source will be NETWORK, indicating a message about the state
of the network connections.
.PP
When entering input, the backspace and delete keys will erase the last
character typed.  The escape key erases the entire input line.  And
pressing control-R causes the entire screen to be redrawn from scratch.
Always press return to have your input transmitted to the other players.
.PP
There is a `default' input option embedded in the input processor.
When the input line is empty, pressing return results in the display
of a `default' input.  When in bidding mode, the default input is
always `pass'.  When in playing mode, the default input is the lowest
ranked card which follows suit.  If there are two or more suits from
which a card may be played, then no default is made available.
Pressing return a second time (i.e., after
the default input has been displayed) causes the default input to be
transmitted to the other players.  Sometimes in playing mode there is
only one legal input.  In this case, this input is displayed
automatically -- you need only press return to transmit it to the
other players.
.PP
In addition, there are a number of control keys which have been
programmed to provide abbreviations for commands.  See the section
on Control Keys and Keyboard Macros below for a description.

.SH "Bidding"
.PP
A contract bid is specified by giving the level and the trump suit.
The level is given as an integer in the range 1-7, while the trump
suits are of course clubs, diamonds, hearts, spades and no trump. 
However, the name of the trump suit is abbreviated to its initial
letter.  Thus, here are some examples of legal contract bids:
.IP  "1c, 1d, 1h, 1s, 1n, 2c, 2d, 2h, 2s, 2n, 3c, 3d, 3h, 3s, 3n, ..."
.IP  "A passing bid is given by entering `pass' or just `p'."
.IP  "A doubling bid is given by entering `double' or `X'."
.IP  "A redoubling bid is given by entering `redouble' or `XX'."
.PP
A bidder may alert his or her bid by typing an exclamation point
after the bid (e.g., 1c!).  This alert is broadcast to the opponents
but not to the partner of the alerting bidder.  Alternatively, the
partner of the bidder may alert the bid by using the /ALERT command
or the control-A key.  See the /ALERT command below.

.SH "Playing"
.PP
The name of a card is specified by giving its suit and then its rank.
The honor cards `ten', `jack', `queen', `king' and `ace' are
abbreviated respectively to T, J, Q, K and A.  Thus, the cards in
the deck are enumerated as

.nf
.na
    C2, C3, C4, C5, C6, C7, C8, C9, CT, CJ, CQ, CK, CA
    D2, D3, D4, D5, D6, D7, D8, D9, DT, DJ, DQ, DK, DA
    H2, H3, H4, H5, H6, H7, H8, H9, HT, HJ, HQ, HK, HA
    S2, S3, S4, S5, S6, S7, S8, S9, ST, SJ, SQ, SK, SA
.ad
.fi

It is allowable to write the rank first and then the suit, e.g., TC
instead of CT.

.SH "Talking to Other Players"

As noted before, messages can be sent to other players by entering
input on the TALK line (line 17 of the display above).  When the
return key is pressed, the message will ordinarily be broadcast to all
of the other players.  This section discusses the conditions under
which this behavior may be modified.
.PP
Messages from other players always appear in the form:

.I  player* message

where the asterisk '*' is replaced by some other character
which indicates the audience of the message.  The character
appearing in place of the asterisk is called the \fPaudience
descriptor\fI.  For example, messages which are seen by everyone
have a colon ':' as the audience descriptor:

.I  player: message, e.g.
.I  Mojo:  Is yellow card OK?

.PP
An observer may reveal the hands of the players by using the /SPEC
command, thus entering \fIspectator\fP mode.  Once an observer
becomes a spectator, talk messages from this observer can only
be seen by other spectators, and not by the players or non-spectating
observers.  In this case, the audience descriptor will be an exclamation
mark '%'.
.PP
A person sitting at the table may direct messages at one or both
opponents.  To send a message to both opponents, use the command
'/OPP message'.  This can be abbreviated to '=message'.  Messages
which are received by the opponents appear with an equals sign '='
as the audience descriptor.
.PP
To send a message to the left hand opponent, use the command
'/LHO message', and to send a message to the right hand opponent,
use the command '/RHO message'.  These commands can be abbreviated
to '-\fIname\fP message', where \fIname\fP is replaced by the
name of the intended recipient of the message.  Messages which
are received by only a single opponent appear with a hyphen '-'
as the audience descriptor.

.SH "Commands"
.PP
There are a number of special commands that are available in the okbridge
program.  These special commands are invoked by entering at the beginning
of a line a slash `/', the name of the command, and perhaps some
parameters.  Each command can be abbreviated to the minimum length
needed to uniquely identify it.  Some of the commands may in addition
appear in the .okbridgerc and .okdefaults initialization files.  (See the
section on initialization below).  These commands will have either "(Saved)"
or "(Init OK)"  listed after the description of command.
Here is a brief list of the available commands:

.IP "/ADDCC <conventions>"
This command adds the conventions to your convention card.

.IP "/ALERT"
Alerts your partner's last bid.  If you are playing in FORMAL mode,
the alert is displayed to your opponents only.  Otherwise, the alert
will be displayed to everyone.  Same as ^A.

.IP "/ADDRESS <player-address>"
Specifies up to one line of information about how you may be reached
by regular mail.  This information is recorded in your user account
for others to view.  See the description of the GPS and user accounts.

.IP "/ATTEND"
This command causes all comments to be displayed, even if they were
previously supposed to be ignored.  See /IGNORE.

.IP "/AUTOPASS [ON|OFF|TOGGLE]"
During \fIPractice\fP mode, this command controls whether or not PASS bids
are automatically supplied by the moderator for absent players.  See the
description of \fIPractice\fP mode below. (Saved)

.IP "/AUTOSAVE [ON|OFF]"
Controls whether or not defaults will automatically be written
to the .okdefaults file. (Init OK)

.IP "/BELL [ON|OFF|TOGGLE]"
By default, the okbridge program rings the terminal's bell whenever
it requests input from you.  However, this can be disabled by
typing /BELL OFF.  The state of the bell can be toggled with ^G. (Saved)

.IP "/CC [NS|EW|MY|BOTH]"
Displays the convention card of the specified team(s).
By default, displays the convention card of the opponents.

.IP "/CCDEF [<Convention Card Name>] [<Convention-Card>]"
Stores or displays a named convention card in the internal database.
If both parameters are omitted, then displays all of the named 
convention cards.  If only the name of the convention card is
specified, then displays that convention card.  Otherwise,
enters a new definition for a named convention card. (Init OK)

.IP "/CNTRL <key-code> [<key-mapping>]"
Remaps one of the control keys, or displays the current mapping
if <key-mapping> is omitted.  See the section below on "Control
Keys and Keyboard Macros."

.IP "/CLAIM [\fIn\fP]"
This command claims \fIn\fP additional tricks for the declarer.  If
\fIn\fP is omitted, then all remaining tricks are claimed.  If \fIn\fP
is negative, then this many -\fIn\fP tricks are conceded.  All hands
are revealed to the defenders, and they are asked whether or not they
agree to the declarer's request.  If both agree, then the hand is
ended early.  This command can be used only by the declarer.  See also
the /DOWN and /MAKE commands.

.IP "/CLS"
Clears all of the messages from the talk area of the display.

.IP "/DEFAULT [ON | OFF]"
This command controls whether or not defaults will be provided
for bids, plays and questions.  This mode can be toggled with ^D. (Saved)

.IP "/DOWN n"
Claims for a total of n tricks below the level of the contract.  
See the /CLAIM command for further details.

.IP "/EMAIL <your-email-address>"
Specifies your email address.  Other players will then be able to
find out your email address by using the /WHOIS command.  This information
is also recorded in your user account record. (Saved)

.IP "/EXIT"
Escapes from any pending input requests.  This command is useful
for aborting results displays and claims.

.IP "/FIND <player1> <player2> ... <playerN>"
Finds the tables where the given players are located, and lists them.

.IP "/FULLNAME <your-full-name>"
Specifies your full name.  Other players will then be able to find
out your name by using the /WHOIS command.  This information is also recorded
in your user account record. (Saved)

.IP "/HELP [topic]"
Provides help about how to use Okbridge.  Type /HELP alone to obtain 
general help.

.IP "/HELPFILE <helpfile-name>"
Specifies the name and location of the OKbridge helpfile.

.IP "/IGNORE <substring>"
This command causes all future comments containing the substring not
to be printed.  This is useful for example if many people are joining
and going into spectator mode, and you don't want to see all of the
messages telling you about them. (Init OK)

.IP "/KEY <key-code> [<key-mapping>]"
Remaps one of the keys, or displays the current mapping
if <key-mapping> is omitted.  See the section below on "Control
Keys and Keyboard Macros."

.IP "/LEVEL <playing-level>"
Specifies your playing level.  This information is recorded in your
user account for view by other players.  Also, when you serve a table,
your level is displayed in the list of tables.  This helps players to
locate tables where they can be challenged by opponents of equal strength.

.IP "/LHO <message>"
Sends a message to the person who will play or bid immediately
after you.  Same as the /RHB command.

.IP "/LOG [\fIfilename\fP] [TEXT|EMAIL|BOTH]"
Typing /LOG \fIfilename\fP causes this hand and subsequent hands
to be written to the file with name \fIfilename\fP.  Omitting
\fIfilename\fP causes the current log file to be closed.
An additional parameter may be specified to indicate the format
of the log file to be kept.  The default is TEXT.  If EMAIL is
specified, then the log file is recorded in email duplicate format.
If BOTH is specified, then a textual record of the play is recorded
to the file \fIfilename\fP, and an email duplicate record of the
play is recorded to the file \fIfilename.em\fP.  (Saved)

.IP "/LOOK [\fItablenumber\fP]"
Typing '/LOOK n' is similar to /REVIEW, but  will  allow  you  to
review  the play of other tables for the same hand.  The number n
corresponds to  the  table  number  which  is  displayed  by  the
/RESULTS command. 

.IP "/LURK"
Returns to the initial state of the program, where you are neither
serving nor connected to another table.

.IP "/LREC"
Records the previous hand played to the record file.  See the /REC
command.

.IP "/MAKE [\fIn\fP]"
If \fIn\fP is omitted, then claims for a number of tricks exactly
equal to the level of the contract.  Otherwise, claims for \fIn\fP
tricks above the level of the contract.

.IP "/META <key-code> [<key-mapping>]"
Remaps one of the meta keys, or displays the current mapping
if <key-mapping> is omitted.  See the section below on "Control
Keys and Keyboard Macros."

.IP "/OPP <message>"
Sends a message which will be seen only by the opponents.

.IP "/PAUSE"
During bidding or play, this restores the entire screen to a talk
display.  This is useful for seeing messages which have scrolled out
of the small conversation area which appears during bidding and play.

.IP "/PING"
Sends an invisible message to each of the other players, which is
automatically echoed.  Reports the round-trip communication time.

.IP "/PRACTICE [ON|OFF]"
Turns on or off the \fIPractice\fP mode of play.  This mode allows
a partnership to practice bidding and the planning of play.  See the
description of \fIPractice\fP mode below.

.IP "/PROMPT [ON|OFF|TOGGLE|NEVER]"
By default, the dummy is asked to press RETURN after the end
of each trick.  This allows the dummy to see each trick as
it is played.  This prompting can be disabled by typing
/PROMPT OFF.  The prompt mode can be toggled with ^P.  
If /PROMPT NEVER is selected, then the user will not be
prompted at any time. (Saved)

.IP "/QUIET [ON|OFF|TOGGLE]"
Changes or displays the state of the quiet mode setting.
In quiet mode, JOIN, QUIT and SPEC messages are not displayed.  (Saved)

.IP "/QUIT"
Terminates the program.

.IP "/REC [\fIfilename\fP] [TEXT|EMAIL|BOTH]"
This opens a log file for recording of hands, similar to the /LOG
command.  However, hands are recorded to the /REC file only on demand.
That is, the player uses the /REC command with a filename to open
a file for recording.  To then record a subsequent hand, the player
uses /REC with no parameters.  The hand is not recorded until it
has been completely played, so the /REC command may be issued at any
time during the play of the hand. (Saved)

.IP "/REMCC <conventions>"
Each of the conventions is removed from the CC if it is on the CC.

.IP "/RESULTS [CURRENT]"
Redisplays the results from the  previous  hand.    If  CURRENT  is
specified,  the results for the current hand are shown.  CURRENT is
only valid if player is a spectator.  For only  a  summary  of  the
results, use /SUMMARY. 

.IP "/REVEAL [<player-name> | NORTH | EAST | SOUTH | WEST"
| NE | NS | NW | SE | SW | EW]
.IP
This command can only be used by an observer or the dummy.  In this
case, the player enters \fIspectator\fP mode and the named hands are
revealed.  In spectator mode, the observer can have complete
information about the game.  Spectators may talk to each other, but
they may not talk to the players or to other observers who are not
spectators.  Spectator mode is not available in formal play.  If the
name of the player is omitted, then all hands are revealed.  (This
command is actually the same as the /SPEC command.)

.IP "/REVIEW"
Displays a review of the previous hand.

.IP "/RHB <message>"
Sends a message to the person who appears to the right of you in
the bidding display.  Same as the /LHO command.

.IP "/RHO <message>"
Sends a message to the person who bids or plays immediately before
you.  Same as the /LHB command.

.IP "/SEAT NORTH|EAST|SOUTH|WEST|OBS"
.IP "/EAST, /NORTH, /OBS, /OBSERVER, /SOUTH, /WEST"
.IP
Selects a seat.  Can only be used before the first hand or between
hands.  Only one person may sit in the seats north, east, south, west,
but there may be many observers.

.IP "/SETCC [<your-convention-card>]"
Enters one line of text as your convention card.  This card will
then be announced to your partner and the opponents as the convention
card for your team.  Omitting convention card from this command will
cause your current convention card to be announced to your partner
and opponents.  If the convention card is just a single word, then
the list of convention cards specified in the .okbridgerc file with
the CCDEF command is searched for a matching entry.  If a matching
entry is found, then the corresponding convention card is used.

.IP "/SHOWALERTS [ON|OFF|TOGGLE]"
Controls whether or not the player sees the alerts made by partner.
This helps to avoid receiving unauthorized information.  (Saved)

.IP "/SHOWRESULTS [ON|SUMMARY|FULL|OFF]"
Controls whether or not the results of play  at  other  tables  are
displayed at the end of each duplicate hand.  Results can be either
shown in summary mode, in full mode, or both (ON). 

.IP "/SPEC [<player-name> | NORTH | EAST | SOUTH | WEST"
| NE | NS | NW | SE | SW | EW]
.IP
This command can only be used by an observer or the dummy.  In this
case, the player enters \fIspectator\fP mode and the named hands are
revealed.  In spectator mode, the observer can have complete
information about the game.  Spectators may talk to each other, but
they may not talk to the players or to other observers who are not
spectators.  Spectator mode is not available in formal play.  If the
name of the player is omitted, then all hands are revealed.  (This
command is actually the same as the /REVEAL command.)

.IP "/STATS [<player-name>]"
Displays information recorded in the GPS about the specified player.
This information includes the player's name, address and level,
as well as the player's performance in GPS duplicate.  If the
<player-name> is omitted, then your information is displayed.

.IP "/SUBCC <old> <new>"
Substitutes new for old in the CC.

.IP "/SUMMARY [CURRENT]"
Redisplays the summary of the results from the previous hand.    If
CURRENT  is  specified, the results for the current hand are shown.
CURRENT is only valid if player is a spectator.  To  see  the  full
display of the results, use /RESULTS. 

.IP "/TIMER [ON|OFF|TOGGLE]"
Changes or displays the state of the timer.  The timer records how
much time has elapsed during the current hand and how much time
has been spent waiting for the local player to enter input.  (Saved)

.IP "/UPDATE [<flags>]"
Updates okbridge with the most recent version.  The <flags> are machine
specific flags, such as '-aix' for the AIX platform and '-hpux' for
the HP/UX platform.  No flags are needed for Suns or NeXTs.

.IP "/WAKEUP [<player-name> | ALL]"
Sends a wakeup signal to the named player, or to all players if
ALL is specified.  The wakeup signal rings the terminal bell and
prints the words "WAKE UP" in the conversation area.  If the name of the
player is omitted, then the signal is sent to your partner.
Pressing ^W is the same as typing /WAKEUP.

.IP "/WHO"
Gives a short list of the other players and their respective seats.

.IP "/WHOIS [<player-name>]"
Inquires about a specific player.  If the player has listed his/her
full name and email address in the .okbridgerc file, then this
information is given.  If <player-name> is omitted, then inquires
about both of the opponents.

.IP "/ZLOG [filename]"
This command is similar to the /LOG command in that it also opens
a log file, but the format of the zlog file is more compact.


.PP
.SH Server Commands

In addition, there are a number of commands which can be used only
by the server.  

.IP "/ASSIGN <player-name> NORTH|EAST|SOUTH|WEST|OBS"
Assigns a player to a given seat.  Can only be used before the
first hand has been dealt or between hands.

.IP "/DISCONNECT <player-name>"
Closes the connection to the named player.  
<player-name> can either be the name of a player (e.g., Worf)
or the name of a position (e.g., SOUTH).

.IP "/FORMAL [OFF|ON]"
Specifies whether formal playing rules will be used or queries which
playing rules are currently use.  In formal play, talk messages
are displayed only to the opponents, alerts are not displayed to the
partner of the alerter, and the dummy is not revealed to anyone
until the opening lead has been made.

.IP "/RESET"
Resets the program to its initial state. 

.IP "/SCORE RUBBER|DUPLICATE|MP|IMP"
Selects a scoring mode.  If the selected scoring mode is different from
the current scoring mode, then the scoring change takes effect
with the next hand.  (Saved)

.IP "/SKIP [\fIn\fP]"
Ends the current hand immediately, without recording a score for it.
If we are the server, then the parameter \fIn\fP specifies the number 
of hands to skip (including the current one).
This command is useful in case the connection to one of the players is lost.

.PP
.SH The Global Player Service

The Global Player Service is a worldwide database of currently playing
bridge tables.  Using the GPS, it is possible to quickly locate other
people wishing to play bridge.  In addition, the GPS controls duplicate
play.  The following commands are for accessing the GPS:

.IP "/TABLES"
Lists the currently playing tables.

.IP "/JOIN [<name>]"
Joins the table being served by <name>.  If <name> is omitted,
then the first table in the list provided by the /TABLES command
is joined.

.IP "/SERVE [<port-number>]"
Begins serving a table.  The table will be advertised to the GPS
automatically, so that other players may join.  If <port-number>
is omitted, then 1729 will be chosen by default.

.PP
The Global Player Service also supports duplicate play.
It maintains a database of boards which have been played by other
foursomes.  These boards can be downloaded and played again, 
and match point scores will then be computed.  
.PP
User accounts have been added as a new feature in OKbridge 1.8.  
Each OKbridge user must establish an account with the GPS.  
When the program is started,
you will be asked to login.  If this is your
first time using OKbridge, you must select an OKbridge account name and
password.  Subsequently, all of the boards that you play will be
recorded under your account name.
.PP
To see the records for your account, use the /STATS command.
You may also want to use the /ADDRESS, /EMAIL, /FULLNAME and /LEVEL
commands so that others can find out some information about you.
The /PASSWORD command can be used to change your password.
WARNING:  IT IS NOT A GOOD IDEA TO USE THE SAME PASSWORD FOR YOUR
OKBRIDGE ACCOUNT AS YOU USE FOR YOUR REGULAR UNIX ACCOUNT.
.PP
Anyone is welcome to setup an OKbridge account.  However, I ask
that you do not create duplicate accounts, because each account record
takes a substantial amount of disk space.  Also, please provide accurate
information for the /ADDRESS, /EMAIL and /FULLNAME fields.  These 
accounts are provided as a courtesy to the OKbridge community.
.PP
In addition, there are the following GPS-related commands:

.IP "/LOGIN [<account-name>]"
Logs into the account with given <account-name>.  You will be prompted
for a password.  If the <account-name> is omitted, then the most recent
account name that you have used is assumed.  (Saved)

.IP "/PASSWORD"
After you have logged in, this command can be used to change your
password.  You will be prompted for your old password and for the
new password.

.IP "/PLAYERS [<name>]"
Lists the names of all of the players currently at the table
served by <name>.  If <name> is omitted, then lists all of the
players at all tables.

.IP "/CONNECT <host_name> [<port_number>]"
Connects to the table being served at <host_name> with port <port_number>.
If <port_number> is omitted, then 1729 is assumed.

.IP "/GPS [ON|OFF|TOGGLE]"
Controls whether or not the GPS is used.  (Init OK)

.IP "/GPS_IP <ip-address-or-number> [<port-number>]"
Specifies the network address of the GPS.  (Init OK)

.IP "/NOTE [<message>]"
Posts a message to the GPS which others will see with the '/PLAYERS'
command.  This command can only be used by the server.

.IP "/PERISH"
If the local player is serving, this removes the local player's table
from the GPS database.  See /PUBLISH.

.IP "/PUBLISH"
If the local player is serving, then this returns the local player's
table to the GPS database.  See /PERISH.

.IP "/SCOREBOARD"
Displays the GPS duplicate scoreboard.  The top ten players in match point
play and in IMP play are listed.

.IP "/YTD"
Displays the current top 10 rankings in the year-to-date scoreboard.


.SH "The .okbridgerc initialization file"
.PP
OKbridge uses two files for initialization.  When the program is started,
these files are read and used to determine some of the initial settings
of the program.  The first file is named .okdefaults, and it contains
information about the settings of the program the last time you used
OKbridge.  This file is rewritten each time you quit the program, so
that .okdefaults maintains a living memory of your current settings.
The second file is named .okbridgerc.  This file is never modified
by OKbridge, and any settings found in this file supercede those
found in .okdefaults.

OKbridge first searches for .okdefaults and .okbridgerc in the current
working directory.  If these files cannot be found there, then your
home directory is searched.  On termination, the .okdefaults file will
be written to your home directory by default.  However, if there is
a copy of .okdefaults in your current working directory, then this
file will be rewritten instead.

The format of both of these files is the same.  Each line is either
a comment or a command.  Comment lines begin with a pound sign '#'.
Commands are in the same format as used for input to the program,
as described above, with the exception that the leading slash '/'
is omitted.  Only a subset of the full command set for OKbridge is
allowed to occur in the .okbridgerc and .okdefaults files.
If the phrase "(Saved)" or "(Init OK)" occurs after the description
of the command, then this command may occur in the .okbridgerc file.
Commands which have "(Saved)" attached to them denote state variables
which will be written to the .okdefaults file when the program terminates.

For an example of an .okbridgerc file, see the file in this
distribution named "okbridgerc".  (Note that it is incorrectly named -- 
to be read by the okbridge program, it should be named ".okbridgerc").

.SH Control Keys and Keyboard Macros

OKbridge allows any key on the keyboard to be reprogrammed.  When a
key is pressed, one of three actions may be taken: (1) text is
inserted into the input input buffer, (2) a keyboard macro is
executed, or (3) a special function is performed.
.PP
In addition to the usual set of keys, OKbridge also provides an
additional set of meta-keys.  A meta-key is invoked by pressing
the meta-key prefix and then pressing a second key which represents
the meta key.  These allow the user to define potentially up to 128
keyboard macros.  The default meta-key prefix, as shown below,
is control-X.
.PP
The /KEY, /CNTRL and /META commands are all closely related.  The /KEY
command can be used to remap any key on the keyboard.  The <key-name>
should either be a decimal ascii code, or it can be an ascii character
if the character is printable.  The /CNTRL command is used to remap the
control keys.  If the <key-name> is a letter (upper or lower case),
then the corresponding control key is remapped.  The /META key is used to 
remap meta-keys.
.PP
The <key-mapping> is interpreted as follows.  If the last character
of the <key-mapping> is a backslash '\\', then the text of the
<key-mapping> is inserted into the input buffer when the key is pressed.
If the first character of the <key-mapping> is a slash '/', then
the <key-mapping> is interpreted as a command which is executed when
the key is pressed.  If the <key-mapping> is the name of one of the special
functions listed below, then that function is executed when the key
is pressed.  Otherwise, the <key-mapping> is interpreted as a talk message
which is sent to the other players when the key is pressed.  To force
a <key-mapping> to be a talk message, it may be enclosed in double
quotes.
.PP
The current set of special functions are as follows:

.nf
.na
   <CR>       Processes the input buffer.
   <BS>       Erases the last character in the input buffer.
   <ERASE>    Erases the entire input buffer.
   <META>     Interprets the next key as a meta-key.
   <ESC>      Exits from current activity.
   <FOCUS>    Switches between playing and talking.
   <REFRESH>  Redraws the screen.
   <NULL>     Ignores the key.
.ad
.fi

.PP
Many of the control keys have default mappings.  These mappings
are listed below:

.nf
.na
    control
    key       mapping               meaning
    -------   -------               -------
    A         /ALERT                Alerts partner's last bid
    B         /BIDS                 Reviews the bidding
    D         /DEFAULT TOGGLE       Toggles default input mode
    E         /EXIT                 Gets out of long displays
    G         /BELL TOGGLE          Toggles the bell
    H <BS>    <BS>                  Erases last character typed
    I <TAB>   <FOCUS>               Switches between playing and talking
    J <LF>    <CR>                  Causes next line to be entered
    L         /REVIEW               Reviews the last hand
    M <CR>    <CR>                  Causes next line to be entered
    P         /PROMPT TOGGLE        Toggles prompt mode
    R         <REFRESH>             Refreshes the display
    T         /TIMER                Updates the timer display
    U         <ERASE>               Erases the input buffer
    V         /SPEC                 Go into spectator (view) mode
    W         /WAKEUP               Sends a wakeup signal to partner
    X         <META>                Interprets next key as a meta-key
    <ESC>     <ESC>                 Exits from current prompt
    <DEL>     <BS>                  Erases last character typed
.ad
.fi

.PP
\fIExamples.\fP  The following statements swap the Refresh and Review keys:

.nf
.na
   /CNTRL R /REVIEW
   /CNTRL L <REFRESH>
.ad
.fi
.PP
The following are some examples of phrases one might wish to
bind to meta keys.  The first three phrases are transmitted
directly as talk messages to the other players as soon as the
corresponding key is pressed.  The fourth phrase is inserted
into the talk buffer, to be completed by the local player before
being transmitted.  The fifth statement toggles the /QUIET mode
flag, which controls whether or not JOIN, QUIT and SPECTATOR
messages are displayed.

.nf
.na
   /META  b Best of luck, partner!
   /META  h Hello!
   /META  t Thank you, partner!
   /META  x Excellent!  I didn't realize we had such a fit in \\
   /META  q /QUIET TOGGLE

.ad
.fi



.SH Partnership Practice Mode

The \fIPractice\fP mode is based on a suggestion of Alan Truscott.  In
this mode, two (or more) players may practice their bidding.  The
moderator (OKbridge) supplies PASS bids for players which are absent.
After the hand has been bid, it is revealed to all of the players.
The players may then discuss and play it.
.PP
To enter \fIPractice\fP mode, the server uses the command '/PRACTICE ON'.
This will deal a new hand and allow the players to bid it.  During the
bidding, OKbridge will supply "PASS" bids for absent players.  Thus, if
North-South is practicing and East-West are absent, then a "PASS" will
be supplied by OKbridge automatically each time it is East or West's turn
to bid.
.PP
This is usually the preferred behavior.  However, for three-player practice,
it may be preferable to allow the third player to bid both hands for one side, 
say East-West.  In this case, the server should use the '/AUTOPASS OFF'
command.  This command will disable PASS bids from being supplied by
the moderator.  The third player can then bid for both East and West by
switching seats with the /EAST and /WEST commands.
.PP
After a contract has been reached, all four hands will be revealed to
each of the players.  The players will be able to discuss the bidding
together.  They can also play out the hand.  Each player is allowed to
play from anyone's hand.  That is to say, if it is West's turn to
play, anyone may select which one of West's cards to play.
.PP
The /CLAIM (or /SKIP) command can be used to end the hand early.
During \fIPractice\fP mode, any player may use the /CLAIM command to
specify the number of tricks to be claimed \fIfor the declarer.\fP
No confirmation is requested for claims made during \fIPractice\fP mode.
After the hand ends, the score is computed and displayed.


.SH Scoring
.PP
The following tables give a basic outline of how okbridge computes
the scores.  It is partially derived from the documentation supplied with
the bridge program written by Yuan and Chu.
.IP "Trick Score (below the line)"
If the contracting team succeeds in making their contract,
then the base score for the hand is computed according to
the following chart.  

.na
.nf
  Spades or Hearts     30 per trick | If doubled:
  Diamonds or Clubs    20 per trick |    multiply by 2
  Notrump        40 for first trick | If redoubled:
       30 for each additional trick |    multiply by 4
.fi
.ad

.IP
For rubber bridge, the score is computed
according to the number of tricks bid.  For other scoring
methods, the score is computed according to how many tricks
were actually made.

.IP
In a doubled contract in rubber bridge, overtricks are
scored at 100 points each if not vulnerable and 200 points
each if vulnerable.  In a redoubled contract in rubber bridge,
overtricks are scored at 200 and 400 respectively.

.IP
In rubber bridge, a game is scored if 100 points or more are
accumulated below the line.  The scoring side then becomes
vulnerable and wins the rubber if they win a second game.
In other forms of bridge, the vulnerability proceeds according
to a rotation which cycles every 16 hands.  

.IP Bonuses
For rubber bridge, there is a bonus for winning the rubber,
which is scored as follows: 

.nf
.na
  Rubber bonus:   500 if you win two games out of three
                  700 if you win the only two games
.ad
.fi
.IP
For all forms of bridge, there is a bonus for making a slam:

.nf
.na
                        Not Vulnerable   Vulnerable
  Slam Bonus:  Small Slam      500           750
               Grand Slam     1000          1500
.ad
.fi
.IP
In rubber, there is a bonus if the contracting
side has enough honor cards in the trump suit:

.nf
.na
  Honors:  4 trump honors in one hand          100
           5 trump honors in one hand          150
           4 aces in one hand at notrump       150
.ad
.fi
.IP
In non-rubber bridge, there is a 300 point bonus for bidding
and making a game when not vulnerable.  The bonus is 500 points
if vulnerable.
.IP
Making Doubled (or redoubled) Contract:	 50 points
.IP
Penalties (above the line):

.nf
.na
                Undoubled              Doubled
             Not Vul.   Vul.      Not Vul.   Vul.
  Down 1        50      100         100      200
  Down 2       100      200         300      500
  Down 3       150      300         500      800
  Down 4       200      400         700     1100
  Down 5       250      500         900     1400
  Down 6       300      600        1100     1700
  Down 7       350      700        1300     2100
  Down 8       400      800        1500     2500
   ...         ...      ...         ...      ...
.ad
.fi

Note that for non-rubber bridge, the penalty sequence for doubled
not vulnerable is 100, 300, 500, 800, 1100, etc.
If redoubled: multiply the doubled penalty by two.

.IP "IMP scoring"
The IMP (International Match Point) scoring system is based on
comparing the results of play for exactly two tables.  In this system,
the difference between the score of your team and the other team who
played the same cards as you is computed and then converted to a
number of IMPs according to a table.

.nf
.na
  Duplicate score  IMP pts     Duplicate score  IMP pts
  ---------------  -------     ---------------  -------
    <  20             0             750            12 
       50             1             900            13
       90             2            1100            14
      130             3            1300            15
      170             4            1500            16
      220             5            1750            17
      270             6            2000            18
      320             7            2250            19
      370             8            2500            20
      430             9            3000            21
      500             10           3500            22
      600             11           4000            23
                                   above           24
.ad
.fi
If more than two tables have played a board, then the IMP score
assigned to a team for the play of a board is the average of all of the
pairwise IMP scores.  If only one table has played a board, then the
IMP score assigned for the play of the board is determined using the
Mono IMP system described by Gary Greene in the May/June 1990 issue
of \fIBridge Today.\fP  Greene describes the Mono IMP system as follows:

"Mono-IMP scoring is based on an average expected score for each side's
high-card-point holding.  The table below shows the average score that
a given number of high-card points will produce in the long run.  I
have compiled statistics from over 10000 hands from a lunchtime game
played over the last five years, and they indicate that these values
are a realistic long-term average."

.nf
.na
     HCP   Vul   NV          HCP   Vul   NV
     ---   ---   ---         ---   ---   ---
     20    0     0      |    29    750   550  
     21    50    50     |    30    800   600  
     22    100   100    |    31    950   700  
     23    150   150    |    32    1100  800  
     24    300   200    |    33    1400  950  
     25    450   300    |    34    1500  1050 
     26    600   400    |    35    1650  1150 
     27    650   450    |    36    1850  1300 
     28    700   500    |    37+   2100  1500 
.ad
.fi

The number of Mono-IMPs awarded is determined by taking the difference between
the score actually made and the predicted score as given in the above table.
If the difference is less than 600 (in either direction), then the number
of Mono-IMPs awarded is equal to the difference divided by 50 and rounded
to the nearest half point.  If the difference is greater than 600, then the
number of Mono_IMPs awarded is equal to 12 plus 1 point for each 100
beyond 600, again rounded to the nearest half point.

.IP "Match Point Scoring"
The Match Point scoring system compares the results of many tables of
play.  A partnership receives one match point for each pair who played
the same hands and did worse than them and a half point for each pair
who scored exactly the same.  In OKbridge, match point scores are
normalized to lie between 0 and 1.  The number of match points which a
team receives is divided by the total number of match points which
could have been won.  Thus, normalized match points represent a per
cent ranking among the other teams who played the board.  If a board
has been played by only one table, then a simulated match point score
is assigned.  The simulated match point score is 1 if the Mono-IMP
score is 1 or greater, 0 if the Mono-IMP score is -1 or less, and 0.5
otherwise.

.SH "Instant Duplicate Play"
The GPS provides an instant duplicate feature.  There are two ongoing
duplicate tournaments.  The first is scored using match points, and the
second is scored using international match points.  At the end of each
week, the results of play from the preceding week are tallied and a
scoreboard is created ranking the players from the preceding week.
.PP
To play in the match point duplicate tournament, the server uses the
command '/SCORE MP'.  Subsequent boards will be downloaded from the
GPS.  After a board is played, all of the players can see the results
of play by a number of other tables and can compare their own play
to those of others.  Each board is scored according to percent match
points.  After each board is played, the percentage score of the partnership
is listed in the MP row of the scoring panel in the upper right corner
of the screen.  
.PP
For both sides, there is also a TOTAL score listed in the scoring
panel.  The TOTAL score for the local player reflects his or her per
cent score as computed over all boards in the current tournament.
Thus, the TOTAL gives an instantaneous ranking of the player as
compared to all other players in this week's tournament.  The TOTAL
score for the opposition just reflects their performance over this
session of play.  If the local player is an observer, then the TOTAL
scores for both sides are just those computed over the current session.
.PP
To play in the international match point duplicate tournament, the
server uses the command '/SCORE IMP'.  As with match point duplicate,
subsequent boards are downloaded from the GPS, and players will be
able to see the results of play at other tables after each board has
been played.  The score received by a partnership for the play of a
board is scored by computing an average IMP score versus each of the
other tables which played the board.  This score is listed in the
IMP row of the scoring panel.
.PP
Again for both sides, there is also a TOTAL score listed in the
scoring panel.  The TOTAL score for the local player reflects an
overall average on all boards played.  This overall average is
computed by keeping a sum over all boards played of the pairwise IMP
scores of the performance of the local player versus each of the other
tables playing the board.  This sum is then divided by the total
number of terms in this sum.  The TOTAL score for the opposition
again just reflects their performance over the current session of play.
If the local player is an observer, then the TOTAL scores listed for
both sides reflect only the current session of play.
.PP
There are three sets of scores maintained by the GPS for each player:
year-to-date scores, last week's scores and the current week's scores.
In each category, your percent matchpoints or average IMPs are computed
according to the above formulas.  In addition, rankings are assigned to
players in each category.  Rankings are listed in the form r/n, where
r is your ranking and n is the total number of players who qualified
for a ranking in this category.
.PP
To qualify for a ranking in the year-to-date scoreboard, you must have
played an average of 20 boards per week or a total of 520 boards, whichever
is lower.  To qualify for a ranking in last week's scoreboard, you must
have played a minimum of 35 boards.
.PP
Everyone who has played at least one board is assigned a ranking in the
current week's scoreboard.  If you have played 35 or more boards, then
you are ranked against all others who have also played at least 35 boards.
If you have played fewer than 35 boards, then you are ranked against
all of those who have played at least as many boards as you have.
Thus, as you play more boards, your ranking should converge to the
final ranking which you will receive at the end of the week.


.SH "Email Duplicate"
.PP
In addition to the GPS duplicate mode described above, okbridge allows
boards to be read from and written to files.  These files can be mailed
to other foursomes for play, allowing for 'email duplicate' matches.
.PP
To begin email duplicate play, the server at the first table uses the
/SAVE command to save a set of boards after they have been played.
The /SAVE command creates a record of the boards along with a complete
record of how they were played.  This file can then be mailed to others
for play.
.PP
To replay a set of boards which have been saved, the server
uses the /LOAD command to load the boards.  This loads the boards
from the file into memory and immediately begins playing them.
After the boards have been played, the server can /SAVE the boards
back to a file.  This will save the previous results of play along
with the new results.
.PP
Alternatively, a sequence of boards can be replayed by using the
/REPLAY command.  This first causes the boards to be read into the
program for play.  After they have been played, they are then
automatically saved along with the results back to the file from
which they were read.
.PP
To create a unplayed set of shuffled boards, use the
.IR okshuffle (6)
program.  Also, to merge a number of boards that have already been
played, you can use the
.IR oktally (6)
program. See their man pages for more details.

.SH "FILES"
".okbridgerc"	- user defaults file
.SH "SEE ALSO"
okshuffle(6),
oktally(6)
.SH AUTHOR
.PP
Matthew Clegg, mclegg@cs.ucsd.edu.
.PP
Man pages adapted by George Ferguson,
.br
ferguson@cs.rochester.edu.
