/* nonstd.c -- nonstandard routines.
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 * This file contains routines which are not available on all systems.
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#ifdef HPUX
#define NO_BCOPY
#define NO_INDEX
#endif

#ifdef VMS
#define NO_STRCASECMP
#define NO_INDEX
#endif

#ifdef SCO
#define NO_STRCASECMP
#endif

#ifdef SOLARIS
#define NO_BCOPY
#define NO_BZERO
#endif

extern char *malloc ();

#ifndef sgi
#ifndef BSD386
char *strdup (s)
	char *s;
{
	char *p, *q;

	if (s == NULL)
	  return (NULL);

	q = p = (char *) malloc (strlen(s) + 1);
	while (*s != '\0')
		*(q++) = *(s++);
	*q = '\0';
	return (p);
}
#endif
#endif

#ifdef NO_ISSPACE
int isspace (ch)
     char ch;
{
  return ((ch == ' ') || (ch == '\t') || (ch == '\n'));
}
#endif

#ifdef NO_BCOPY
void bcopy (from, to, len)
     char *from, *to; int len;
{
  while (--len >= 0)
    *(to++) = *(from++);
}
#endif

#ifdef NO_BZERO
void bzero (dest, len)
     char *dest; int len;
{
  while (--len >= 0)
    *(dest++) = '\0';
}
#endif

#ifdef NO_INDEX
char *index (s, c)
     char *s, c;
{
  return (strchr(s,c));
}
#endif

#ifdef NO_STRCASECMP
int strcasecmp (s1, s2)
     char *s1, *s2;
{
  char c1, c2;

  c1 = *(s1++); c2 = *(s2++);
  while (c1 && c2) {
    if (('a' <= c1) && (c1 <= 'z')) c1 = c1 - 'a' + 'A';
    if (('a' <= c2) && (c2 <= 'z')) c2 = c2 - 'a' + 'A';
    if (c1 < c2)
      return (-1);
    else if (c2 < c1)
      return (1);
    c1 = *(s1++); c2 = *(s2++);
  }
  if ((c1 == 0) && (c2 == 0))
    return (0);
  else if (c1 == 0)
    return (-1);
  else
    return (1);
    
}

int strncasecmp (s1, s2, count)
     char *s1, *s2; int count;
{
  int i, c1, c2;

  for (i = 0; i < count; i++) {
    c1 = *(s1++); c2 = *(s2++);
    if ((c1 == 0) && (c2 == 0))
      return (0);
    else if (c1 == 0)
      return (-1);
    else if (c2 == 0)
      return (1);
    if (('a' <= c1) && (c1 <= 'z')) c1 = c1 - 'a' + 'A';
    if (('a' <= c2) && (c2 <= 'z')) c2 = c2 - 'a' + 'A';
    if (c1 < c2)
      return (-1);
    else if (c2 < c1)
      return (1);
  }
  return (0);
}
#endif
