/* log.h -- routines for writing log files.
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 */

/*
int sort_direction = 1;

This variable should be set to 1 if scores should be sorted by decreasing
score of N-S, and it should be set to -1 if scores should be sorted by
increasing score of N-S.
*/

extern char Play_picture [][81];

int Create_Picture_of_Hand ();
/* Creates an image of the board b and play record p in the picture array.
 * Returns the number of lines used in the array. 
 */

void Write_hand ();
/* Writes the board b with play record p to the file f in an expanded
 * format which is similar to that found in bridge books.
 */

void Write_hand_compactly ();
/* Writes the board b with play record p to the file f in a brief format
 * which was introduced by S. Zhang.
 */

void sprint_summary_header ();
/* Writes to the buffer buf the header which is used in the scoring
 * summaries. 
 */

void sprint_summary_record ();
/* Writes to the buffers buf1 and buf2 the scoring summary for the board b
 * and play record p.
 */

void Write_summary_of_play ();
/* For each play record associated to the board b, writes a single line
 * summary describing the result of play.
 */

void Sort_play_records_by_matchpoints ();
/* Sorts the set of play records for the board b according to the match
 * point scores.
 */

void Sort_play_records_by_imps ();
/* Sorts the set of play records for the board b according to the
 * imp scores.
 */
