/* help.h -- help functions for the bridge program.
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 * This file contains the interface for a help procedure for the
 * bridge program.  The help function is organized as a series of topics,
 * headed by a main topic.  All of the help information is stored in a
 * single file, organized as a list of topics.  The first entry in the
 * file is interpreted to be the main topic, i.e., it is the entry which
 * is displayed if no particular keyword is given.  Each topic entry
 * has a header line which contains an identifying keyword and a 
 * descriptive phrase.  This is followed by the body of the entry
 * and is terminated by an end-of-entry line.  The format of the header
 * line is simply
 *  <keyword> <phrase>
 * where <keyword> is any text string not containing white space characters.
 * The body of the entry consists simply of a series of text lines.
 * These are displayed in order on the screen.  However, a line beginning
 * with the circumflex '^' character is displayed at the beginning of a
 * new page.  A help entry is terminated by a line containing just the
 * two characters '--'.  The last entry in the file need not have this
 * terminator.  The help file may also contain comment lines.  These
 * begin with the pound sign '#' character.
 */
 
extern initialize_help_system ();
/* Called once at the beginning of the program to read the file of help
 * topics.
 */

extern void display_news ();
/* Checks if there is any new news regarding OKbridge available on the
 * local system.  If yes, then displays the news file.
 */

extern int display_help ();
/* void display_help (char *topic); */
/* Displays help on the given topic.  This consists of looking up the
 * help file associated to this topic and displaying the contents of this
 * file on the screen.  If the topic string is empty, then displays first
 * the contents of the main topic file.  Returns 0 if the requested topic
 * was found, and 1 otherwise.
 */
 
extern void browse_help ();
/* void browse_help (char *name); */
/* Displays help on the given topic.  Afterwards, displays a list of
 * topics along with a request to enter the name of a new topic.
 */

extern void display_topics ();
/* void display_topics (char *header_message); */
/* Displays the list of help topics. */

extern void Refresh_Help_Display ();
/* void Refresh_Help_Display (void); */
/* Redisplays the current screen of help information. */

extern void Clear_Help_Display ();
/* void Clear_Help_Display (void); */
/* Returns the help system to its initial state. */
