/* GPS_client.h -- global playing service, client interface.

   Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved

   OKbridge is made available as a free service to the Internet.
   Accordingly, the following restrictions are placed on its use:

   1.  OKbridge may not be modified in any way without the explicit 
       permission of Matthew Clegg.  

   2.  OKbridge may not be used in any way for commercial advantage.
       It may not be placed on for-profit networks or on for-profit
       computer systems.  It may not be bundled as part of a package
       or service provided by a for-profit organization.

   If you have questions about restrictions on the use of OKbridge,
   write to mclegg@cs.ucsd.edu.

   DISCLAIMER:  The user of OKbridge accepts full responsibility for any
   damage which may be caused by OKbridge.


   The global playing service is a global database of player information.
   In the initial implementation, it will contain only information
   about currently playing tables.  At a later date, we will add
   capabilities for downloading sets of boards and playing competitively.

   Unfortunately, this module is not re-entrant.  This can be a bit of a
   pain since the GPS_read_line procedure calls Wait_for_input in
   input.c, which in turn calls Wait_for_event in network.c.
*/

#ifdef GPS

  int Use_GPS = 1;      
    /* A boolean flag indicating that we will provide information about 
       our table to the GPS. */

  int GPS_unavailable = 0;  
    /* A boolean flag indicating that an error occurred last time we tried
       to access the GPS. */

  int GPS_socket = 0;
    /* If nonzero, the socket descriptor of our currently open connection. */

  int GPS_request_in_progress = 0;
    /* A boolean flag which indicates that a GPS operation is currently
       being serviced.  This flag is used by the network module when
       setting up the select flags and also to detect if we experienced 
       a reset during our last request. */

  int suspend_gps_input = 0;
    /* A boolean flag which if true instructs the network module
       to ignore any input waiting for the GPS. */

  char GPS_server_message [71] = "\0";

#else

  extern int Use_GPS, GPS_unavailable, GPS_socket, GPS_request_in_progress,
    suspend_gps_input;
  extern char GPS_server_message[];

#endif


void GPS_Get_Message_of_the_Day ();
/* void GPS_Get_Message_of_the_Day (); */
/* Contacts the GPS and prints out the "message of the day". */

int GPS_Get_Server_IP ();
/* int GPS_Get_Server_IP (char *server_name, char *location, int *port); */
/* Searches the list of currently playing tables for a server whose name
   matches server_name.  If one is found, then copies the corresponding
   location and port to the buffers provided by the caller, and returns 0.
   If no match is found, returns 0.
*/

void GPS_Broadcast_Server ();
/* void Broadcast_Server (void); */
/* Sends a message to the global player service notifying it that we
   are serving a table.  Sends the names of each of the players at the
   table in the message.
*/

void GPS_Broadcast_Server_Silently ();
/* Same as GPS_Broadcast_Server but does not print an error message if
   we are not using the GPS or if the GPS was found to be unavailable
   in a previous call.
*/

void GPS_Advertise_Message ();
/* void GPS_Advertise_Message (char *message); */
/* If we are in server mode, then displays the given message along with
   our table announcement in the tables display. */

void GPS_List_Tables ();
/* void GPS_List_Tables (void); */
/* Contacts the GPS for a list of the currently playing tables.
   Lists the tables at the terminal.
*/

void GPS_List_Players ();
/* void GPS_List_Players (char *server); */
/* Lists the players at the given table. */

void GPS_End_Server_Mode ();
/* void GPS_End_Server_Mode (); */
/* Informs the GPS that we are no longer serving a table. */

void GPS_Reset ();
/* void GPS_Reset (); */
/* Resets the state of our GPS connection. */

void GPS_Directory ();
/* void GPS_Directory (void); */
/* Returns a listing of the email duplicate files which are available. */

int GPS_Download ();
/* int GPS_Download (char *download_file); */
/* Downloads the specified file from the global player service. 
   Returns 0 if successful and 1 if unsuccessful.
*/

void GPS_Dup ();
/* void GPS_Dup (int scoring_mode); */
/* Initiates gps duplicate mode.  Scoring mode should be either 
 * MP_SCORING or IMP_SCORING.
 */

Board *GPS_Get_Next_Board ();
/* void GPS_Get_Next_Board (void); */
/* Downloads the next duplicate board from the GPS. */

void GPS_Upload_Play_Record ();
/* void GPS_Upload_Play_Record (Play_record *p); */
/* Uploads the play record p for the current email board to the GPS. */

Board *GPS_Download_Results ();
/* Board *GPS_Download_Results (char *player_name); */
/* Downloads the all of the recorded results in the GPS for the given 
 * player.  Returns a list of boards or NULL if no results are available.
 */

void GPS_Send_Playing_Time ();
/* void  GPS_Send_Playing_Time (long seconds); */
/* Sends the playing time for the local player in seconds to the GPS. */

void GPS_Add_Player ();
/* void GPS_Add_Player (Connection c); */
/* Advises the GPS that the player represented by connection c has joined
   the table. */

void GPS_Delete_Player ();
/* void GPS_Delete_Player (Connection c); */
/* Advises the GPS that the player represented by connection c has left
   the table. */

void GPS_Move_Player ();
/* void GPS_Move_Player (Connection c); */
/* Advises the GPS of the current seat held by the player with connection c.*/

void GPS_Refresh_Players ();
/* void GPS_Refresh_Players (void); */
/* Sends complete information about the seats held by all players at this
   table. */

void GPS_Get_Scores ();
/* void GPS_Get_Scores (Score *mp, Score *imp); */
/* Downloads the current scores for the local player. */

int GPS_Check_for_Login ();
/* int GPS_Check_for_Login (char *login_name); */
/* Returns TRUE if there is an account assigned to login_name, and false
   otherwise. */

int GPS_Login ();
/* int GPS_Login (char *login_name, char *pw); */
/* Attempts to login the using the given login_name and pw.  If successful,
   returns a non-negative id assigned by the GPS.  Otherwise, returns -1
   and prints an error message. */

int GPS_Create_Account ();
/* int GPS_Create_Account (char *login_name, char *pw); */
/* Creates an account with given login_name and pw.  If successful, returns
   a non-negative id assigned by the GPS.  Otherwise, returns -1 and prints
   an error message.
*/

void GPS_Change_Password ();
/* void GPS_Change_Password (char *oldpw, char *newpw); */
/* Attempts to change the password for the user. */

void GPS_Display_Stats ();
/* void GPS_Display_Stats (char *player_name); */
/* Displays the statistics for the given player. */

void GPS_Set_Field ();
/* void GPS_Set_Field (char *field_name, char *field_value); */
/* Sets an informational field for the local player. */

void GPS_Perish ();
/* void GPS_Perish (void); */
/* If we are serving, then removes the current table from the GPS. */

void GPS_Publish ();
/* void GPS_Publish (void); */
/* Restores the current table to the GPS listing. */
