/* fds.h
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 * This code was contributed by aaron@cie.uoregon.edu (Aaron Putnam).
 *
 * It provides definitions for the FD_ macros for those systems which
 * do not define them.
 */


#ifndef FD_SETSIZE
#  define FD_SETSIZE  64
#endif

#ifndef FD_ZERO
#  define FD_ZERO(x) ((x)->fds_bits[0] = 0)
#endif

#ifndef FD_SET
#  define FD_SET(y,x) ((*(x)).fds_bits[0] |= (1 << (y)))
#endif

#ifndef FD_CLR
#  define FD_CLR(y,x) ((*(x)).fds_bits[0] & (1 << (y)))
#endif

#ifndef FD_ISSET
#  define FD_ISSET(y,x) ((*(x)).fds_bits[0] & (1 << (y)))
#endif

