/* conversation.h -- process messages at conversation level.
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 */

typedef int (* event_signal) ();
  /* The wait for event routines below take as a parameter a pointer to
     a function which returns true when the event in question has occurred.
  */

void Handle_Conversation_Message ();
/* Processes the message m.  If the message is a conversation message, then
 * takes appropriate action based on the message.  Appends the message
 * to the appropriate conversation queue if further action is warranted.
 */

void Wait_for_event_at_conversation_level ();
/* Receives incoming messages at all tables.  Handles keyboard characters
 * and messages which arrive on the protocol queues.  Each time a keyboard
 * character is received or a new message is processed, the event_signal
 * routine is called.  If it returns true, then the procedure exits.
 */

void Wait_for_event_at_game_level ();
/* Receives incoming messages at all tables.  Handles keyboard characters
 * and messages which arrive on the protocol and conversation queues.  Each
 * time a keyboard character is received or a new message is processed, the
 * event_signal e routine is called.  If it returns true, then the procedure
 * exits.  
 */

Table Wait_for_conversation_message ();
/* Receives incoming message at all tables.  Handles keyboard characters
 * and messages which arrive on the protocol queues.  When a message is
 * placed onto the conversation queue of a table, returns a pointer to
 * the table. */

Table Wait_for_game_message ();
/* Receives incoming messages at all tables.  Handles keyboard characters
 * and messages which arrive on the protocol and game queues.  When a message
 * is placed onto the game queue of a table, returns a pointer to the table.
 */

