/* cipher.h
 *
 ! Copyright (C) 1990-1992 by Matthew Clegg.  All Rights Reserved
 ! 
 ! OKbridge is made available as a free service to the Internet.
 ! Accordingly, the following restrictions are placed on its use:
 ! 
 ! 1.  OKbridge may not be modified in any way without the explicit 
 !     permission of Matthew Clegg.  
 ! 
 ! 2.  OKbridge may not be used in any way for commercial advantage.
 !     It may not be placed on for-profit networks or on for-profit
 !     computer systems.  It may not be bundled as part of a package
 !     or service provided by a for-profit organization.
 ! 
 ! If you have questions about restrictions on the use of OKbridge,
 ! write to mclegg@cs.ucsd.edu.
 ! 
 ! DISCLAIMER:  The user of OKbridge accepts full responsibility for any
 ! damage which may be caused by OKbridge.
 *
 * This file provides definitions for a module which implements a
 * very simple cipher that is used to encode crucial parts of the
 * email duplicate files.  The purpose of the cipher is to allow
 * email duplicate files to be manipulated easily without revealing
 * their contents.  For details about how the cipher is implemented,
 * see the file code.c.
 *
*/

#define CIPHER_INCLUDED

#define CIPHER_SIZE	64
#define CIPHER_SIZE1	65

typedef struct Cipher_struct {
  /* For more information about the meanings of these fields, see the
     header of file code.c */
  int encoding  [CIPHER_SIZE1];  /* The permutation p */
  int decoding  [CIPHER_SIZE1];
} Cipher, *Cipher_ptr;


int Read_Cipher_Descriptor ();
/*  Reads a cipher descriptor from the file f.  Returns 0 if successful
    or 1 if an error occurred. */

void Write_Cipher_Descriptor ();
/* Writes the cipher descriptor c to the file f. */

void Create_Cipher_Descriptor ();
/* Fills the structure c with a randomly generated cipher descriptor. */

void Encode_String ();
/* Encodes the string in source, placing the result in dest.
   If c == NULL, then simply copies source to dest. */

void Decode_String ();
/* Decodes the string in source, placing the result in dest.
   If c == NULL, then simply copies source to dest. */

void Write_Ciphered_Line ();
/* Encodes buf using the cipher c and writes it to the file f. 
   The first character written to the file is an exclamation point '!' */

int Read_Ciphered_Line ();
/* Reads a line of up to buflen characters from the file f and decodes
   the line using the cipher c.  If the first character of the line
   is not an exclamation point '!', then the line is assumed to be
   in plain text.  Returns the number of characters read or -1 if
   end of file is reached.
*/
