/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: util.h,v 34000.3 1994/08/05 12:53:46 kkeys Exp $ */

#ifndef UTIL_H
#define UTIL_H

#include "regexp/regexp.h"

typedef struct Aline {         /* shared line, with attributes */
    char *str;
    unsigned int len;
    short links, attrs;
    short *partials;
    TIME_T time;
} Aline;

typedef struct Pattern {
    char *str;
    regexp *re;
} Pattern;

/* Modulo arithmetic: remainder is positive, even if numerator is negative. */
#define nmod(n, d)   (((n) >= 0) ? ((n)%(d)) : ((d) - ((-(n)-1)%(d)) - 1))
#define ndiv(n, d)   (((n) >= 0) ? ((n)/(d)) : (-((-(n)-1)/(d))-1))

/* Note STRNDUP works only if src[len] == '\0', ie. len == strlen(src) */
#define STRNDUP(src, len) \
    (strcpy(dmalloc((len) + 1, __FILE__, __LINE__), (src)))
#define STRDUP(src)  STRNDUP((src), strlen(src))


#define IS_QUOTE	001
#define IS_STATMETA	002
#define IS_STATEND	004

extern char tf_ctype[];

#define is_quote(c)	(tf_ctype[(unsigned char)c] & IS_QUOTE)
#define is_statmeta(c)	(tf_ctype[(unsigned char)c] & IS_STATMETA)
#define is_statend(c)	(tf_ctype[(unsigned char)c] & IS_STATEND)


#ifdef HAVE_STRTOL
# define strtochr(sp)   ((char)(strtol(*(sp), sp, 0) % 128))
# define strtoi(sp)     ((int)strtol(*(sp), sp, 10))
#else
extern char   FDECL(strtochr,(char **sp));
extern int    FDECL(strtoi,(char **sp));
#endif
extern void   NDECL(init_util);
extern void   NDECL(init_mail);
extern char  *FDECL(print_to_ascii,(CONST char *str));
extern char  *FDECL(ascii_to_print,(CONST char *str));
extern char  *FDECL(cstrchr,(CONST char *s, int c));
extern char  *FDECL(estrchr,(CONST char *s, int c, int e));
extern int    FDECL(numarg,(char **str));
extern char  *FDECL(stringarg,(char **str, char **end));
extern void   NDECL(regrelease);
extern void   FDECL(reghold,(regexp *re, CONST char *str, int temp));
extern int    FDECL(regexec_and_hold,(regexp *re, CONST char *str, int temp));
extern int    FDECL(regsubstr,(struct String *dest, int n));
extern int    FDECL(init_pattern,(Pattern *pat, CONST char *str, int mflag));
extern int    FDECL(patmatch,(Pattern *pat, CONST char *str, int mflag,
                    int temp));
extern void   FDECL(free_pattern,(Pattern *pat));
extern int    FDECL(smatch,(CONST char *pat, CONST char *str));
extern int    FDECL(smatch_check,(CONST char *s));
extern char  *FDECL(stripstr,(char *s));
extern void   FDECL(startopt,(char *args, CONST char *opts));
extern char   FDECL(nextopt,(char **arg, int *num));
extern Aline *FDECL(dnew_aline,(CONST char *str, int attrs, CONST char *file,
                    int line));
extern void   FDECL(dfree_aline,(Aline *aline, CONST char *file, int line));
#define new_aline(s,a)     dnew_aline((s), (a), __FILE__, __LINE__)
#define free_aline(al)     dfree_aline((al), __FILE__, __LINE__)
extern void   NDECL(ch_mailfile);
extern void   NDECL(ch_maildelay);
extern void   NDECL(check_mail);
extern int    FDECL(parsetime,(char **strp, int *istime));
extern TIME_T FDECL(abstime,(int hms));
extern char  *FDECL(tftime,(CONST char *fmt, TIME_T t));
extern void   FDECL(die,(CONST char *why, int err)) NORET;

#endif /* UTIL_H */
