/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: tf.h,v 34000.6 1994/08/29 00:12:43 hawkeye Exp $ */

#ifndef TF_H
#define TF_H

/*
 * TinyFugue global types and variables.
 */

/* History sizes are now defined at runtime with /histsize and %histsize. */

#define RESTRICT_SHELL  1
#define RESTRICT_FILE   2
#define RESTRICT_WORLD  3

typedef char smallstr[65];     /* Short buffer */

#define Queue List

#define F_COLORMASK  0000017   /* low 4 bits are interpreted as an integer */
#define F_COLOR      0000020   /* flag */
#define F_UNDERLINE  0000040
#define F_REVERSE    0000100
#define F_FLASH      0000200
#define F_DIM        0000400
#define F_BOLD       0001000
#define F_HILITE     0002000
#define F_BELL       0004000

#define F_GAG        0010000
#define F_NOHISTORY  0020000
#define F_SUPERGAG   (F_GAG | F_NOHISTORY)
#define F_NORM       0040000

#define F_INDENT     0100000

#define F_SIMPLE     (F_UNDERLINE | F_REVERSE | F_FLASH | F_DIM | F_BOLD)
#define F_HWRITE     (F_SIMPLE | F_HILITE | F_COLOR | F_COLORMASK | F_BELL)
#define F_ATTR       (F_HWRITE | F_SUPERGAG | F_NORM)


/* Macros for defining and manipulating bit vectors of arbitrary length.
 * We use an array of long because select() does, and these macros will be
 * used with select() on systems without the FD_* macros.
 */

#ifndef NBBY
# define NBBY 8                                   /* bits per byte */
#endif
#ifndef LONGBITS
# define LONGBITS  (sizeof(long) * NBBY)          /* bits per long */
#endif

#define VEC_TYPEDEF(type, size) \
    typedef struct { long bits[(((size) + LONGBITS - 1) / LONGBITS)]; } (type)

#define VEC_SET(n,p)   ((p)->bits[(n)/LONGBITS] |= (1 << ((n) % LONGBITS)))
#define VEC_CLR(n,p)   ((p)->bits[(n)/LONGBITS] &= ~(1 << ((n) % LONGBITS)))
#define VEC_ISSET(n,p) ((p)->bits[(n)/LONGBITS] & (1 << ((n) % LONGBITS)))
#ifndef HAVE_BCOPY   /* assume memcpy implies memset and bcopy implies bzero. */
# define VEC_ZERO(p)   memset((char *)(p)->bits, '\0', sizeof(*(p)))
#else
# define VEC_ZERO(p)   bzero((char *)(p)->bits, sizeof(*(p)))
#endif


/* headers needed everywhere */

#ifndef TIME_H
# include <time.h>    /* for time_t */
# define TIME_H
#endif
#include "malloc.h"
#include "variable.h"

/* hook definitions */

extern short   VDECL(do_hook,(int indx, CONST char *fmt, CONST char *argfmt, ...));

enum Hooks {
  H_ACTIVITY,
  H_BACKGROUND,
  H_BAMF,
  H_CONFAIL,
  H_CONFLICT,
  H_CONNECT,
  H_DISCONNECT,
  H_KILL,
  H_LOAD,
  H_LOADFAIL,
  H_LOG,
  H_LOGIN,
  H_MAIL,
  H_MORE,
  H_PENDING,
  H_PROCESS,
  H_PROMPT,
  H_REDEF,
  H_RESIZE,
  H_RESUME,
  H_SEND,
  H_SHADOW,
  H_SHELL,
  H_SIGHUP,
  H_SIGTERM,
  H_SIGUSR1,
  H_SIGUSR2,
  H_WORLD,
  NUM_HOOKS                              /* not a hook, but a count */
};

#define ALL_HOOKS  (~(~0L << NUM_HOOKS))

#endif /* TF_H */
