/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: malloc.h,v 34000.3 1994/09/25 22:11:07 hawkeye Exp $ */

#ifndef MALLOC_H
#define MALLOC_H

#define MALLOC(size) xmalloc((size), __FILE__, __LINE__)
#define REALLOC(ptr, size) xrealloc((ptr), (size), __FILE__, __LINE__)
#define FREE(ptr) xfree((GENERIC*)(ptr), __FILE__, __LINE__)

#define xfree(ptr, file, line) dfree((GENERIC*)(ptr), (file), (line))

#ifdef DMALLOC
extern GENERIC  *FDECL(dmalloc,(long unsigned size,
                       CONST char *file, CONST int line));
extern GENERIC  *FDECL(drealloc,(GENERIC *ptr, long unsigned size,
                       CONST char *file, CONST int line));
extern void   FDECL(dfree,(GENERIC *ptr, CONST char *file, CONST int line));
#else
# define dmalloc(size, file, line) malloc(size)
# define drealloc(ptr, size, file, line) realloc((GENERIC*)(ptr), (size))
# define dfree(ptr, file, line) free((GENERIC*)(ptr))
#endif

extern GENERIC  *FDECL(xmalloc,(long unsigned size,
                       CONST char *file, CONST int line));
extern GENERIC  *FDECL(xrealloc,(GENERIC *ptr, long unsigned size,
                       CONST char *file, CONST int line));

/* Fast allocation from pool.
 * Should be used only on objects which are dallocated frequently.
 */
#define palloc(item, type, pool, next) \
    ((pool) ? \
      ((item) = (pool), (pool) = pool->next) : \
      ((item) = (type *)MALLOC(sizeof(type))))
#define pfree(item, pool, next)  (item->next = (pool), (pool) = (item))


#endif /* MALLOC_H */
