/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: malloc.c,v 34000.2 1994/09/25 22:10:00 hawkeye Exp $ */

#ifndef DMALLOC

#include "config.h"
#include "port.h"
#include "signals.h"
#include "malloc.h"

GENERIC *xmalloc(size, file, line)
    long unsigned size;
    CONST char *file;
    CONST int line;
{
    GENERIC *ret;

    if ((long)size <= 0 || !(ret = (GENERIC*)dmalloc(size, file, line)))
        core("xmalloc(%ld) failed.", file, line, (long)size);
    return ret;
}

GENERIC *xrealloc(ptr, size, file, line)
    GENERIC *ptr;
    long unsigned size;
    CONST char *file;
    CONST int line;
{
    GENERIC *ret;

    if ((long)size <= 0 || !(ret = (GENERIC*)drealloc(ptr, size, file, line)))
        core("xrealloc(%ld) failed.", file, line, (long)size);
    return ret;
}

#endif
