/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: macro.h,v 34000.2 1994/08/15 00:43:20 hawkeye Exp $ */

#ifndef MACRO_H
#define MACRO_H

typedef struct Macro {
    char *name;
    struct ListEntry *numnode;		/* node in list by number */
    struct ListEntry *trignode;		/* node in list by priority */
    struct ListEntry *hooknode;		/* node in list by hook */
    struct ListEntry *hashnode;		/* node in list in hash bucket */
    struct Macro *tnext;		/* temp list ptr for collision/death */
    char *bind, *body;
    Pattern trig, hargs, wtype;		/* trigger/hook/worldtype patterns */
    int hook;				/* bit vector, at least 32 bits */
    struct World *world;		/* only trig on text from world */
    int pri, num;
    short attr, subexp, subattr;
    short prob, shots, invis, temp, dead, fallthru, mflag;
} Macro;

extern void   NDECL(init_macros);
extern short  FDECL(parse_attrs,(char **argp));
extern Macro *FDECL(find_macro,(CONST char *name));
extern Macro *FDECL(new_macro,(CONST char *name, CONST char *trig,
                    CONST char *binding, int hook, CONST char *hargs,
                    CONST char *body, int pri, int prob, int attr, int invis));
extern int    FDECL(add_macro,(struct Macro *macro));
extern int    FDECL(add_hook,(char *name, CONST char *body));
extern int    FDECL(remove_macro,(char *args, int attr, int byhook));
extern void   NDECL(nuke_dead_macros);
extern void   FDECL(kill_macro,(struct Macro *macro));
extern void   FDECL(remove_world_macros,(struct World *w));
extern int    FDECL(save_macros,(char *args));
extern int    FDECL(do_macro,(Macro *macro, CONST char *args));
extern CONST char *FDECL(macro_body,(CONST char *name));
extern int    FDECL(find_and_run_matches,(char *text, int hook, Aline**alinep));

#define add_ibind(key, cmd) \
    add_macro(new_macro("", NULL, key, 0, NULL, cmd, 0, 0, 0, TRUE))

#endif /* MACRO_H */
