/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: dstring.h,v 34000.1 1994/07/17 01:11:35 hawkeye Exp $ */

#ifndef DSTRING_H
#define DSTRING_H

typedef struct String {
    char *s;
    unsigned int len, size;
} String, Stringp[1];          /* Stretchybuffer */

/* This saves time, but can't be used in reentrant functions.
 * Pre-ANSI C didn't allow initialization of automatic aggregates,
 * so we can only use this technique for static and nonlocal buffers.
 */
#define STATIC_BUFFER(name) static Stringp (name) = { { NULL, 0, 0 } }

#define Stringinit(str)			dSinit(str, __FILE__, __LINE__)
#define Stringfree(str)			dSfree(str, __FILE__, __LINE__)
#define Stringadd(str, c)		dSadd(str, c, __FILE__, __LINE__)
#define Stringnadd(str, c, n)		dSnadd(str, c, n, __FILE__, __LINE__)
#define Stringterm(str, n)		dSterm(str, n, __FILE__, __LINE__)
#define Stringcpy(dest, src)		dScpy(dest, src, __FILE__, __LINE__)
#define SStringcpy(dest, src)		dSScpy(dest, src, __FILE__, __LINE__)
#define Stringncpy(dest, src, n)	dSncpy(dest, src, n, __FILE__, __LINE__)
#define Stringcat(dest, src)		dScat(dest, src, __FILE__, __LINE__)
#define SStringcat(dest, src)		dSScat(dest, src, __FILE__, __LINE__)
#define Stringncat(dest, src, n)	dSncat(dest, src, n, __FILE__, __LINE__)

#define FL	CONST char *file, int line

extern String *FDECL(dSinit,(Stringp str, FL));
extern void    FDECL(dSfree,(Stringp str, FL));
extern String *FDECL(dSadd, (Stringp str, int c, FL));
extern String *FDECL(dSnadd,(Stringp str, int c, unsigned n, FL));
extern String *FDECL(dSterm,(Stringp str, unsigned n, FL));
extern String *FDECL(dScpy, (Stringp dest, CONST char *src, FL));
extern String *FDECL(dSScpy,(Stringp dest, CONST Stringp src, FL));
extern String *FDECL(dSncpy,(Stringp dest, CONST char *src, unsigned n, FL));
extern String *FDECL(dScat, (Stringp dest, CONST char *src, FL));
extern String *FDECL(dSScat,(Stringp dest, CONST Stringp src, FL));
extern String *FDECL(dSncat,(Stringp dest, CONST char *src, unsigned n, FL));

#undef FL

#endif /* DSTRING_H */
