;;; Aliases.
; Create command aliases.  Like simple macros, but no leading '/' is required.
; syntax:  /alias <name> <command...>
; syntax:  /unalias <name>

/~loaded alias.tf

/if /test alias =~ ""%; /then \
    /echo Note: alias argument substitution has changed.  %%1 and %%2 now \
          refer to the first and second arguments, as you would expect, \
          instead of the alias name and the first argument, as in the old \
          version.  You can enable the old behavior with "/set alias=old".  \
          You can gag this message if you /set alias to "old" or "new" before \
          you /load this file.%;\
/endif

/def -i alias = \
    /if /test %# < 2%; /then \
        /quote -S /~listalias `/list -i alias_%{1-*}%; \
    /else \
        /let body=%-1%;\
;       The alias_* macro /shifts unless [alias=~"old"] at runtime.
        /def -i -ag -mglob -h"send {%1}*" alias_%1 = \
            /shift $$[alias !~ "old"]%%; \
            %body%; \
    /endif

; note: the parameters below depend directly on the format of the /def above.
/def -i ~listalias = /echo /alias $[substr(%9, 6, 99999)] %-14

/def -i unalias = /undef alias_%1

