/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: malloc.h,v 33000.3 1994/05/26 02:24:27 hawkeye Exp $ */

#ifndef MALLOC_H
#define MALLOC_H

#define MALLOC(size) dmalloc((size), __FILE__, __LINE__)
#define REALLOC(ptr, size) drealloc((ptr), (size), __FILE__, __LINE__)
#ifdef DMALLOC
#define FREE(ptr) dfree((GENERIC*)(ptr), __FILE__, __LINE__)
#else
#define FREE(ptr) free((GENERIC*)(ptr))
#endif

extern GENERIC  *FDECL(dmalloc,(long unsigned size,
                       CONST char *file, CONST int line));
extern GENERIC  *FDECL(drealloc,(GENERIC *ptr, long unsigned size,
                       CONST char *file, CONST int line));
#ifdef DMALLOC
extern void   FDECL(dfree,(GENERIC *ptr, CONST char *file, CONST int line));
#endif

#endif /* MALLOC_H */
