/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: malloc.c,v 33000.3 1994/05/26 02:24:27 hawkeye Exp $ */

#ifndef DMALLOC

#include "config.h"
#include "port.h"
#include "signals.h"
#include "malloc.h"

GENERIC *dmalloc(size, file, line)
    long unsigned size;
    CONST char *file;
    CONST int line;
{
    GENERIC *ret;
    char buf[65];

    if ((long)size <= 0) {
        sprintf(buf, "%s:%d dmalloc: size = %ld", file, line, (long)size);
        core(buf);
    }
    if (!(ret = (GENERIC*)malloc(size))) core("% malloc failed");
    return ret;
}

GENERIC *drealloc(ptr, size, file, line)
    GENERIC *ptr;
    long unsigned size;
    CONST char *file;
    CONST int line;
{
    GENERIC *ret;
    char buf[65];

    if ((long)size <= 0) {
        sprintf(buf, "%s:%d drealloc: size = %ld", file, line, (long)size);
        core(buf);
    }
    if (!(ret = (GENERIC*)realloc(ptr, size))) core("% realloc failed");
    return ret;
}

#endif
