/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: history.h,v 33000.5 1994/06/10 17:51:12 hawkeye Exp $ */

#ifndef HISTORY_H
#define HISTORY_H

# ifndef NO_HISTORY

typedef struct History {       /* circular list of Alines, and logfile */
    struct Aline **alines;
    int size, maxsize, pos, index, num;
    TFILE *logfile;
    char *logname;
} History;

extern void   NDECL(init_histories);
extern void   FDECL(init_history,(History *hist, int maxsize));
extern void   FDECL(free_history,(History *hist));
extern void   FDECL(recordline,(History *hist, Aline *aline));
extern void   FDECL(record_input,(char *line));
extern int    FDECL(recall_history,(char *args, TFILE *file));
extern int    FDECL(recall_input,(int dir, int searchflag));
extern void   FDECL(check_watch,(History *hist, Aline *aline));
extern int    FDECL(history_sub,(char *pattern));

#define record_global(aline)  recordline(globalhist, (aline))
#define record_local(aline)   recordline(localhist, (aline))

extern History globalhist[], localhist[];

# else /* NO_HISTORY */

#define init_histories()               /* do nothing */
#define free_history(hist)             /* do nothing */
#define recordline(hist, aline)        /* do nothing */
#define record_global(line)            /* do nothing */
#define record_local(line)             /* do nothing */
#define record_input(line)             /* do nothing */
#define recall_history(args, file)     (eprintf("history disabled"), 0)
#define recall_input(dir, searchflag)  (eprintf("history disabled"), 0)
#define check_watch(hist, aline)       /* do nothing */
#define history_sub(pattern)           (0)

# endif /* NO_HISTORY */

#endif /* HISTORY_H */
