/*	rename.c		4/10/92
 *
 * Copyright 1991  Perry R. Ross
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 */

#include "ldb.h"


/*----------------------------------------------------------------------
 *	rename -- rename a file
 *
 * This function may be used to rename a file if the local C library
 * does not have such a function.  It uses the link and unlink calls,
 * which should be on all systems, but is not atomic like real rename's.
 * This rename is not meant for general use, as it does no error checking.
 * Since it is only used to save the old copy of a file as a backup,
 * it is better to fail silently than complain about something the user
 * can't do anything about anyway.  The old file is always unlinked,
 * even if the link to the new name succeeded, since the next thing
 * we are going to do is write over the old file anyway.
 *----------------------------------------------------------------------
 */

rename(old,new)
char *old;
char *new;
{

unlink(new);		/* get rid of existing file named NEW */
link(old,new);		/* make link from OLD to NEW */
unlink(old);		/* get rid of link to OLD */
}
