/*	lock.c		4/28/92
 *
 * Copyright 1992  Perry R. Ross
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 */

#include "ldb.h"


/*----------------------------------------------------------------------
 *	get_lock -- attempt to open a lock file, exit if it exists
 *
 * This function attempts to create a file in such a way that,
 * if the file exists, the create will fail.  If the create succeeds,
 * we "own" the ldb lock, and have the exclusive right to access
 * the ldb data files in this directory.  If the create fails,
 * some other ldb already has the lock and we exit.
 *
 * This uses the O_EXCL flag to open, which as far as I know is
 * supported on all UNIX flavors.  If it isn't on yours:
 *	a. Please mail me at ross@emf780.den.mmc.com and tell me
 *	   what your system is.
 *	b. try replacing open(fn,O_...,0644) with creat(fn,0444).
 *----------------------------------------------------------------------
 */

get_lock(fn)
char *fn;
{
int fd;
struct stat s;

if ( (fd = open(fn,O_WRONLY|O_CREAT|O_EXCL,0644)) < 0) {
	printf("ERROR: Ldb is already running in this account -- exiting.\n\n");
	printf("If you are sure no other ldb is active, you can remove\n");
	printf("the lock with the following command:\n\n");
#ifdef VMS
	printf("\t$ delete sys$login:%s;*\n",fn);
#else
	if (*fn == '/')
		printf("\t$ rm %s\n",fn);
	else
		printf("\t$ rm $HOME/%s\n",fn);
#endif
	printf(
	"\nPlease be certain no other ldb is running before doing this.\n\n");
	if (stat(fn,&s) >= 0)
		printf("The lock file was created %s\n",ctime(&s.st_ctime));
	exit(STAT_ABORT);	/* DON'T call ldbexit, it calls release_lock */
	}
close(fd);		/* success, close the file and return */
}
