#! /bin/csh -x
set host=cs.umb.edu home=/u/ra/ugrad/mrubin/ldb user=mrubin
source /usr/local/lib/.cshrc
set nonomatch fld='^From |^Return-Path:' edscr=(-e 's/<//g' -e 's/>//g')
cd $home
setenv LDBRC $home/starter.ldbrc
setenv HOME $home
# first handle bad addresses.
cd badaddr
set f=(*)
if ("$f" == "*") set f=""
foreach x ($f)
	set rptmp=(`egrep "($fld)" $x | awk '{print $2;}' | tail -1 | sed $edscr`)
	set rp=$rptmp[$#rptmp]
	set to=(`fgrep To: $x | tail -1 | sed 's/To://g'`)
	echo "`date`  badaddr		$rp	$to" >> ../ldbstarter.log
	mail -s "Mail to invalid ldb address" $rp:q <<EOF

----------------------------------------------------------------------
	The following is an automatic reply from
	the ldb game starter at $host.

	The address you sent to:
		$to
	is not a valid ldb starter address.  For more information,
	send a message to ldb-help@$host.
----------------------------------------------------------------------

EOF
	rm $x
end
# Now handle all requests for more information.
cd $home/help
set f=(*)
if ("$f" == "*") set f=""
foreach x ($f)
	set rptmp=(`egrep "($fld)" $x | awk '{print $2;}' | tail -1 | sed $edscr`)
	set rp=$rptmp[$#rptmp]
	echo "`date`  help		$rp" >> ../ldbstarter.log
	mail -s "Information on automatic ldb game starter" $rp:q <<EOF

----------------------------------------------------------------------
	The following is an automatic reply from
	the ldb game starter at $host.

Welcome to the automatic ldb game starter system.  Ldb is a program that
allows two people to easily play backgammon by e-mail.  This system
uses the remote start capability of ldb to automatically start a
game between two people of similar ability.  Before you can use
the ldb starter, you will need to get and compile ldb on your system.
Ldb is accessible via anonymous ftp from ftp.uu.net or any other host that
archives the comp.sources.misc newsgroup.  Retrieve all parts, uncompress
them, un-tar them, and read the file README for compilation and
installation instructions.  Ldb runs on most 32-bit UNIX systems
and on VAXes under VMS 5.0 or higher.

To use the ldb starter, simply send a mail message to one of the
following addresses:
	ldb-novice@$host
	ldb-intermediate@$host
	ldb-expert@$host
depending on what level of ability you are at.  You choose your level
of play for yourself, there are no restrictions on which level you
play at.  The game starter system does not keep any record of your
level, or whether you win or lose.  It is merely a convenient way
to meet new backgammon players that are at more or less the same
level of ability as you are.  It doesn't matter what you put in
the message, the game starter only uses your return address.
The message can be empty as far as the game starter is concerned,
but your local mail program may complain about empty messages.

Each time you send a message to one of the above addresses, you are
matched at random with another person who sent to the same address.
Each message you send only starts one game.  When you are ready for
another game, you must send another message.

The game starter will try to avoid having you play yourself,
but it cannot guarantee this will not happen if you send
multiple requests to the same address within a short time.
To avoid this problem, only send one request at a time, and
do not send another one until the first game has been started.

Note that there could be an arbitrary delay between when you
send the message and when the game is started.  The game starter
does not currently send acknowledgements other than the
actual start command.  This is sent to one of the two opponents
at random, and will not reach the other one until the first
processes it through ldb.

This system will work best with "pure" domain-style e-mail addresses.
It *should* work with UUCP addresses too, but there could be problems
with this, since the path messages take to get to the game starter
may not be the same path they should take to get to your opponent.
If you want ldb to use an address for you other than the return
address from your message, put the following line in your message:

Return-Path: address@you.wanna.use.instead

The Return-Path: must be at the beginning of the line, and must be
exactly as shown (case *is* significant).

Please note that this system is still experimental.  If you have a
problem using it, or if you have questions about ldb or the
automatic game starter, contact Perry Ross by e-mail at
ross@emf780.den.mmc.com or Mark Rubin by e-mail at mrubin@cs.umb.edu.

Good Luck!
----------------------------------------------------------------------

EOF
	rm $x
end
foreach x (novice intermediate expert)
	cd $home/$x
	set z=$x
	if ($x != intermediate) set z="$x	"
	set y=(`ls | head -2`)
	while ($#y > 1)
		set u1tmp=(`egrep "($fld)" $y[1] | awk '{print $2;}' | tail -1 | sed $edscr`)
		set u1=$u1tmp[$#u1tmp]
		set u2tmp=(`egrep "($fld)" $y[2] | awk '{print $2;}' | tail -1 | sed $edscr`)
		set u2=$u2tmp[$#u2tmp]
		if ("$u1" == "$u2") then	# duplicate
			rm $y[1]		# eliminate one of them
			set y=(`ls | head -2`)	# and try again
			continue
		endif
		/u/ra/ugrad/mrubin/bin/sun4/ldb -remotestart $u1:q $u2:q
		rm $y
		echo "`date`  $z	$u1:q $u2:q" >> ../ldbstarter.log
		set y=(`ls | head -2`)
	end
end
exit
