/*	ldb.h		8/3/91
 *
 * Copyright 1991  Perry R. Ross
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 */

#include "patchlevel.h"

	/* LDB_VER breaks if REVISION or PATCHLEVEL > 9, see patchlevel.h */
#define LDB_VER	((VERSION*100)+(REVISION*10)+PATCHLEVEL)  /* used in sendpkt */

#include <stdio.h>
#include <ctype.h>
#include <curses.h>
#include <signal.h>

#ifdef VMS

#include <types.h>
#include <time.h>
#include <unixio.h>
#include <file.h>
#include <descrip.h>
#include <processes.h>
#include <ssdef.h>
#include <rms.h>
#include <stat.h>
#define STAT_NORM SS$_NORMAL
#define STAT_ABORT SS$_ABORT
#define SYS_GOOD 1		/* success return from system() */

#else

#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>
#include <time.h>
#include <fcntl.h>
#define STAT_NORM 0
#define STAT_ABORT 1
#define SYS_GOOD 0		/* success return from system() */

#endif

#ifdef NEED_READDIR		/* defined by Makefile */
extern struct direct dirbuf;	/* simulate Berkeley directory routines */
#define DIR FILE
#define opendir(X) fopen((X),"r")
#define readdir(X) (fread(&dirbuf,sizeof(dirbuf),1,(X))?&dirbuf:NULL)
#define closedir(X) fclose(X)
#endif

#ifdef vaxc
#define OLD_CURSES 1
#define unlink(X) delete(X)
#endif

#ifdef sequent
#define OLD_CURSES 1
#endif

#ifdef OLD_CURSES		/* defined above or in Makefile */
#define cbreak() crmode()	/* from ancient curses */
#define nocbreak() nocrmode()
#endif

#ifdef USE_INDEX		/* defined in Makefile */
#define strchr index		/* $%!@^&#$ pick a name and stick with it */
#define strrchr rindex
#endif

#define release_lock(X) unlink(X)	/* delete lock file */

	/* swiped from X toolkit */
#define Offset(T,F) ((int)(((char *)(&(((T)NULL)->F)))-((char *)NULL)))

#define PRIVATE static		/* for private functions */

#define INTGFILE "interrupt.ldbdata"	/* file to save games to on ^C */
#define INTPFILE "interrupt.ldbpeople"	/* file to save people to on ^C */

#define BLANKS(X) (&blk76[76-(X)])	/* blank string of specified length */

		/* locations in board typedef */
#define UPBAR		0		/* BAR point for up-bound player */
#define DOWNBAR		25		/* BAR point for down-bound player */
#define UPOFF		26		/* off point for up-bound player */
#define DOWNOFF		27		/* off point for down-bound player */
#define BOARDSIZE	28		/* number of points in board */

	/* BARPT takes a direction (-1 or 1) and returns the	*/
	/* point in the board typedef that represents that	*/
	/* players bar.  OFFPT does the same thing for the	*/
	/* point that pieces go to when they are thrown off.	*/
	/* REV(direction) returns the opposite direction.	*/
#define BARPT(D)	(((D)>0)?UPBAR:DOWNBAR)
#define OFFPT(D)	(((D)>0)?UPOFF:DOWNOFF)
#define REV(D)		(-(D))

		/* states we can be in */
#define ST_OPSTART	0		/* we have sent a START (or rcvd one)*/
#define ST_OPTURN	1		/* Its the opponent's turn */
#define ST_OPACCEPT	2		/* I have offered to double */

#define OPSTATES	3		/* < OPSTATES needs remote input */

#define ST_MYTURN	3		/* My turn, I haven't rolled yet */
#define ST_MYMOVE	4		/* I've rolled, but I haven't moved */
#define ST_MYACCEPT	5		/* Opponent has offered to double */
#define ST_GAMEOVER	6		/* game is dead, see T_* for reason */
#define NSTATE		7		/* number of possible states */

		/* operations to send or receive */
#define START		0		/* start a game */
#define USTART		1		/* if rcvd, we won the initial roll */
#define TIE		2		/* tie on initial roll, restart */
#define MOVE		3		/* send a move */
#define OFRDBL		4		/* offer to double */
#define ACPTDBL		5		/* double accepted */
#define DECDBL		6		/* double declined, game over */
#define CONCEDE		7		/* we give up */
#define RSTART		8		/* remote start packet */
#define RESTART		9		/* repeat initial roll */
#define MSTART		10		/* start next game of match */
#define RESEND		11		/* resend request from opponent */
#define NOTIFY		12		/* tell game starter when game ends */
#define NOP		13		/* number of possible operations */

		/* termination codes for state ST_GAMEOVER */
#define T_ICONCEDE	1		/* I gave up */
#define T_IDECLINE	2		/* I declined double */
#define T_ILOSE		3		/* opponent moved all pieces off */
#define T_OPCONCEDE	4		/* opponent gave up */
#define T_OPDECLINE	5		/* opponent declined double */
#define T_IWIN		6		/* I moved all pieces off */

		/* flags passed to apply */
#define A_REDRAW	1	/* redraw the pieces moved */
#define A_CHKONLY	2	/* check move but don't move pieces */

		/* codes returned by apply */
#define MVOK		0	/* move was accepted by apply() */
#define RJ_NOROLL	-1	/* move does not contain valid roll */
#define RJ_NOOFF	-2	/* all pcs not in inner tbl, can't throw off */
#define RJ_NOPIECE	-3	/* no piece at specified point */
#define RJ_OCC		-4	/* destination occupied */
#define RJ_ONBAR	-5	/* can't move, pieces are on bar */
#define RJ_NOTYOURS	-6	/* wrong color, dummy */
#define RJ_EXACT	-7	/* must use exact roll except for outer pc */

		/* bits for flags field of game struct */
#define F_IDOUBLED	1	/* I doubled last */
#define F_SENTNAME	2	/* I've sent my name */
#define F_INVERT	4	/* I want my board upside down */
#define F_DELETE	8	/* this game is deleted */
#define F_JACOBY	16	/* jacoby rule in effect for this game */
#define F_CRAWFORD	32	/* crawford rule in effect for this game */
#define F_PERM		64	/* permanent game */
#define F_EUROPE	128	/* european rule (backgammons count double) */
#define F_DISPLAYED	256	/* Game over, keeping in case need resend */
#define F_CRGAME	512	/* This game is the crawford rule game */
#define F_CRDONE	1024	/* The crawford rule game has been played */

		/* field types for reading name/value files */
#define FT_CHAR		1	/* store a single character */
#define FT_INT		2	/* store a single integer */
#define FT_STRING	3	/* store a char * (use save()) */
#define FT_MOVE		4	/* a struct mv */
#define FT_BOARD	5	/* a board image */
#define FT_STRLKUP	6	/* lookup string in table & store index */
#define FT_TIME		7	/* a timestamp */
#define FT_INTARRAY	8	/* array of integers */
#define FT_END		99	/* end of structure */

		/* which board is currently displayed (g->curbd) */
#define BD_BEFOP	0	/* before op's move (after my previous) */
#define BD_AFTOP	1	/* after op's move (before my next) */
#define BD_CUR		2	/* current (with any moves I've made so far) */

		/* these are the command line options */
#define OPT_START	1	/* start a game */
#define OPT_READ	2	/* read incoming mail */
#define OPT_PLAY	3	/* play any games that are waiting for me */
#define OPT_COLOR	4	/* set the color for created games */
#define OPT_DIRECTION	5	/* set the direction for created games */
#define OPT_RSTART	6	/* remote start a game */
#define OPT_HELP	7	/* print long help */
#define OPT_CONTROL	8	/* go into control mode */
#define OPT_MYADDR	9	/* set my e-mail address (override .ldbrc) */
#define OPT_BCAST	10	/* send a mail message to all opponents */
#define OPT_JACOBY	11	/* enable the jacoby rule */
#define OPT_CRAWFORD	12	/* enable the crawford rule */
#define OPT_PERM	13	/* make game permanent */
#define OPT_MATCH	14	/* set number of points in match */
#define OPT_EUROPE	15	/* enable european rule */
#define OPT_RECONS	16	/* reconstruct a game from opponent's data */
#define OPT_SCORE	17	/* print cumulative scores */
#define OPT_NOTIFY	18	/* set notify address */

		/* these are the different game states for the help call */
#define STATE_CONTROL	1	/* Invoked with the control option */
#define STATE_MYTURN	2	/* Waiting for user to move */
#define STATE_MYMOVE	3	/* User has rolled but needs to move */
#define STATE_MYACPT	4	/* Accept or decline the double */
#define STATE_GAMEOVER	5	/* The game is over */

#define WHO_ME		0	/* used to mean local player */
#define WHO_OPP		1	/* used to mean opponent */

	/* these bits are passed to findppl to specify whether	*/
	/* we want to look up an address, an alias, or both	*/
#define P_ADDR		1	/* look for a address */
#define P_ALIAS		2	/* look for an alias */

	/* these are the bits to set in rc.debug to enable	*/
	/* debug messages for various functions.		*/
#define DB_READFILE	1	/* print mail files scanned */
#define DB_RWGAMES	2	/* print games read/written */
#define DB_GSTART	4	/* print games started */
#define DB_RSTART	8	/* trace remote start packets */

	/* these refer to the elements of struct people->score */
#define SC_GAMESWON	0	/* number of games won against this guy */
#define SC_GAMESLOST	1	/* number of games lost to this guy */
#define SC_PTSWON	2	/* number of points won against this guy */
#define SC_PTSLOST	3	/* number of points lost to this guy */
#define SC_GMNWON	4	/* number of gammons won */
#define SC_GMNLOST	5	/* number of gammons lost */
#define SC_BGWON	6	/* number of backgammons won */
#define SC_BGLOST	7	/* number of backgammons lost */
#define SC_MWON		8	/* number of matches won */
#define SC_MLOST	9	/* number of matches lost */

struct opt {			/* used to make list of command line options */
	char	*name;		/* name of option (as used on command line) */
	int	index;		/* OPT_* */
	char	*args;		/* arguments the option takes, if any */
	char	*help;		/* 1-line help string for option */
	};

struct ldbrc {		/* struct where all fields from .ldbrc are stored */
	char	*myaddr;	/* my e-mail address */
	char	*myname;	/* my name */
	char	*pfile;		/* people file */
	char	*gfile;		/* games file */
	char	*gbackup;	/* where to save old game file */
	char	*mfile;		/* mail file */
	char	*delmail;	/* should we delete mail files after reading?*/
	char	*lockfile;	/* ldb mutex lock file */
	char	*sendcmd;	/* mail send command */
	char	*tempfile;	/* temp file for sendpkt */
	char	*defclrs;	/* default colors (2 from [rwb]) */
	char	*defdir;	/* default direction (up/down) */
	char	*initboard;	/* init. brd display (before/after/current) */
	char	*autoroll;	/* enable autoroll? (yes/no) */
	char	*automove;	/* enable automove? (yes/no) */
	int	autodouble;	/* autodouble count, 0 to disable */
	char	*supercmd;	/* command to run to fool supervisor */
	char	superkey;	/* key to activate supercmd */
	char	*chkpt;		/* keep games up to date? */
	int	acctime;	/* number of days until auto resend */
	int	keepold;	/* number of days to keep finished games */
	int	debug;		/* debug level, 0 = none */
	};

		/* the following structure is used to save/load */
		/* the games file, the .ldbrc, and to send	*/
		/* packets between the players.  It stores a	*/
		/* name, the type (see FT_* above), and the	*/
		/* offset into a structure.  A pointer to the	*/
		/* structure is provided at runtime.		*/
struct namevalue {
       char *name;		/* name of the field */
       char type;		/* type of the field (T_*) */
       int offset;		/* where to store value */
       int dflt;		/* default value */
       };

union nvtypes {			/* convert char* to/from FT_* */
	char	*nvchar;	/* FT_CHAR */
	int	*nvint;		/* FT_INT */
	long	*nvtime;	/* FT_TIME */
	char	**nvstring;	/* FT_STRING */
	struct mv *nvmove;	/* FT_MOVE */
	struct point *nvboard;	/* FT_BOARD */
	};

struct flist {			/* list returned by filelist() */
	char	*name;		/* file name */
	struct flist *next;	/* forward link */
	};

struct mv {
	char	roll;			/* # on 1 die, 0 = DOUBLE, -1=empty */
	char	pt;			/* point move is from, -1=UNUSED */
	};

struct point {
	char	qty;			/* number of pieces on this point */
	char	color;			/* color of pieces on this point */
	};

typedef struct point board[BOARDSIZE];	/* board is array of points */

struct game {				/* all info about a game in progress */
	char	*gameid;		/* unique game id */
	char	*opaddr;		/* email path to opponent */
	char	*opname;		/* full name of opponent */
	char	*myaddr;		/* my address for this user */
	char	mycolor;		/* char to represent my pieces */
	char	opcolor;		/* opponent's pieces */
	char	mydir;			/* 1/-1 direction I am moving */
	char	opdir;			/* 1/-1 direction opponent is moving */
	int	gameval;		/* current value of game */
	int	adcnt;			/* current number of autodoubles */
	int	admax;			/* max autodoubles allowed */
	int	flags;			/* various flags (F_*) */
	int	opver;			/* opponent's ldb version */
	char	state;			/* my current state (ST_*) */
	char	term;			/* if game over, why (T_*) */
	int	seq;			/* sequence number of next pkt */
	int	lastop;			/* last opcode sent (for resends) */
	char	*mycmt;			/* comment I sent with last move */
	char	*mycmt2;		/* second line of mycmt */
	char	*opcmt;			/* comment I received with last move */
	char	*opcmt2;		/* second line of opcmt */
	char	*dispmsg;		/* msg to display when game drawn */
	struct mv opmvs[4];		/* opponent's last move */
	char	blot[4];		/* my blots that were hit */
	struct mv mvs[4];		/* my move, holds roll until I move */
	int	maxused;		/* # of rolls in mvs that can be used*/
	int	hiused;			/* highest roll that can be used */
	board	opbd;			/* board image before opmvs applied */
	board	mybd;			/* board before mvs (for Reset) */
	board	board;			/* current board image */
	char	curbd;			/* which brd is currently displayed */
	int	rolls[6];		/* how many of each roll we get */
	int	doubles[6];		/* how many of each double we get */
	int	oprolls[6];		/* how many of each roll op gets */
	int	opdoubles[6];		/* how many of each double op gets */
	long	starttime;		/* time START packet was sent */
	long	lastacc;		/* last time game was accessed */
	int	mcurrent[2];		/* current match scores for me & op */
	int	mtotal;			/* match score we are playing to */
	char	*notify;		/* address to mail to when game over */
	struct people *ppl;		/* side pointer to people record */
	struct game *prev;		/* back link in game list */
	struct game *next;		/* forward link in game list */
	};

struct packet {
	int	version;		/* ldb version */
	long	timestamp;		/* time packet was sent */
	char	*gameid;		/* the gameid string */
	int	opcode;			/* operation being performed */
	char	*name;			/* name */
	char	*addr;			/* mail address */
	char	*comment;		/* comment received */
	char	*comment2;		/* second line of comment */
	int	seq;			/* sequence number */
	char	*colors;		/* colors of new game */
	char	*dir;			/* direction of game starter */
	char	*autodbl;		/* autodouble count (sprintf'ed) */
	struct mv mvs[4];		/* moves (if opcode == MOVE) */
	char	*jacoby;		/* yes=jacoby rule in effect */
	char	*crawford;		/* yes=crawford rule in effect */
	char	*european;		/* yes=european rule in effect */
	char	*perm;			/* yes=permanent game */
	char	*match;			/* number of points in match */
	char	*notify;		/* address to notify when game ends */
	struct game *gameptr;		/* not a pkt field, set by getpkt() */
	};

struct people {				/* people we play with */
	char	*name;			/* person's name */
	char	*addr;			/* person's mail address */
	char	*alias;			/* person's nickname */
	char	*myaddr;		/* my addr for this person */
	char	*equiv;			/* equiv name for ppl w/ mult addr */
	long	fence;			/* start time of newest finished game*/
	int	score[10];		/* won/lost record, see SC_* */
	struct people *next;		/* forward link */
	};

struct legal {				/* list of legal moves */
	int nmove;			/* number of moves in this entry */
	int himove;			/* highest roll used in this entry */
	struct mv mvs[4];		/* the rolls and moves */
	struct legal *prev;		/* pointer to the previous entry */
	struct legal *next;		/* pointer to the previous entry */
	};

extern int Pflag;			/* should I process local input? */
extern int Rflag;			/* should I look for mail? */
extern struct game *ghead;		/* head of linked list of games */
extern struct game *gtail;		/* tail of linked list of games */
extern struct legal *lhead;		/* head of list of legal moves */
extern struct legal *ltail;		/* tail of list of legal moves */
extern int (*func[OPSTATES][NOP])();	/* receive state machine */
struct ldbrc rc;			/* stuff from .ldbrc */
extern struct opt options[];		/* command line options */
extern char *rejlcl[];			/* error messages for local player */
extern char *rejmsg[];			/* error messages for received moves */
extern char *opcodes[];
extern char blk76[];			/* 76 blanks */
extern struct packet P;			/* last packet read */
extern char cr_mycolor;			/* my color when game is created */
extern char cr_opcolor;			/* opponent's color for new games */
extern char cr_mydir;			/* my direction for new games */
extern char *notify;			/* address to notify when game ends */
extern char *states[];			/* description of the states */

extern char FeIsActive;			/* front-end been initialized? */
extern char FeWaitInit;			/* non-0 if message() called */
extern int GameState;			/* Current game state for help */
extern int boardnums[3];		/* board name -> board number */

extern struct people *phead;		/* head pointer of people list */

extern struct namevalue nv_rcfile[], nv_gfile[], nv_packet[], nv_pfile[];
extern struct namevalue nv_pequiv[];

char *tgetstr();
char *save(), *makeid(), *calloc();
char *nvscan(), *strchr(), *boardstr();
char *strchr(), *strrchr();
struct game *startgame(), *addgame(), *findgame();

struct people *addppl(), *findppl(), *newppl();

int start(), istart(), tie(), restart(), mstart();
int opmove(), opofr(), opconc(), opacpt(), opdec();
int smerr();

long rnd_ri();

char FeMenu();

struct flist *filelist();
