/*	flist_vms.c		4/24/92
 *
 * Copyright 1992  Earle Ake and Perry Ross
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 */

#include "ldb.h"


/*----------------------------------------------------------------------
 *	filelist -- generate a list of all matching files.
 *
 * This function generates a list of all files that match a pattern.
 * Each file is stored in an instance of struct flist, which just
 * links the names in a linked list.  A pointer to the beginning of
 * the list is returned.  It is the callers responsibility to free
 * the list when it is no longer needed.
 *----------------------------------------------------------------------
 */

struct flist *filelist(ptn)
char *ptn;
{
char nextfile[257];
int context = 0;
struct flist *head, *tail, *cur;

head = NULL;
while (1) {
	if (scan_files(ptn,&nextfile,&context) == 0)
		return(head);
	if ( (cur = (struct flist *) calloc(sizeof(struct flist),1)) == NULL)
		fatal("Out of memory!");
	if (head == NULL) {
		head = cur;
		tail = cur;
		}
	else {
		tail->next = cur;
		tail = cur;
		}
	cur->name = save(nextfile);
	}
}


/*----------------------------------------------------------------------
 *	scan_files -- find the next file matching a pattern
 *
 * This function finds the next (or first) file matching a given
 * pattern.  The pattern is interpreted in the same way as DCL.
 * If the pattern does not specify a version number, ';*' is
 * the default.  scan_files returns 1 if a file was found,
 * 0 if there are no more matching files.
 *----------------------------------------------------------------------
 */

int scan_files(itm_files,nextfile,context)
	char *itm_files, *nextfile;
	int *context;
{
	char *def_spec = ";*";
	int status;
	unsigned key[2];
	char fnam[257], *s;
	static struct RAB itmrab;
	static struct dsc$descriptor itm_dsc, defspec_dsc;
	$DESCRIPTOR(fnam_dsc,fnam);

	if (*context == 0) {
		itm_dsc.dsc$w_length = strlen(itm_files);
		itm_dsc.dsc$b_dtype = DSC$K_DTYPE_T;
		itm_dsc.dsc$b_class = DSC$K_CLASS_S;
		itm_dsc.dsc$a_pointer = itm_files;

		defspec_dsc.dsc$w_length = strlen(def_spec);
		defspec_dsc.dsc$b_dtype = DSC$K_DTYPE_T;
		defspec_dsc.dsc$b_class = DSC$K_CLASS_S;
		defspec_dsc.dsc$a_pointer = def_spec;

		itmrab.rab$l_kbf = (char *) key;
		itmrab.rab$b_krf = 0;
		itmrab.rab$b_ksz = 8;
		itmrab.rab$l_rop = RAB$M_RRL | RAB$M_NLK ;
		itmrab.rab$b_rac = RAB$C_KEY;
	}

	if ((status = lib$find_file(&itm_dsc,&fnam_dsc,context,
		&defspec_dsc,0,0,0)) & 1) {

		fnam[256] = '\0';

		if (s = strchr(fnam,' ')) *s = '\0';
		strcpy(nextfile,&fnam);
		return 1;
		}
	else {
		lib$find_file_end(context);
	}
	return 0;
}
