/* dostats.c		4/20/92
 *
 * Copyright 1992  Earle F. Ake
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 *
 * Original coding by Earle F. Ake <ake@dayton.saic.com> - 20 April 1992.
 *
 */

#include "ldb.h"

/*----------------------------------------------------------------------
 *	dostats -- display online statistics of dice rolls
 *
 * This function creates a new curses window and displays dice statistics
 * to the user.  The user then presses any key to return to the game.
 *----------------------------------------------------------------------
 */

dostats(g)
struct game *g;
{
WINDOW *statwin;
int row, i, col, rolls, dice;
int mypip, oppip;
char temp[80];
char c;
int Total = 0, OpTotal = 0;

statwin = newwin(0,0,0,0);	/* get a new window to post help to */

mvwaddstr(statwin,0,30,"ldb Dice Statistics");		/* print title */
mvwaddstr(statwin,1,30,"-------------------");		/* underline title */
row = 3;

mvwaddstr(statwin,row++,0,"You:");
mvwaddstr(statwin,row++,0,"----");

row++;
mvwaddstr(statwin,row++,0,"Singles   1  2  3  4  5  6  Doubles   1  2  3  4  5  6");
temp[0] = '\0';
for (i = 0; i < 6; i++) {
	sprintf(temp, "%s%3d", temp, g->rolls[i]);
	Total += (g->rolls[i] * (i+1));
	}
sprintf(temp, "%s          ",temp);
for (i = 0; i < 6; i++) {
	sprintf(temp, "%s%3d", temp, g->doubles[i]);
	Total += (g->doubles[i] * (i+1) * 4);
	}

mvwaddstr(statwin,row++,8,temp);
row++;
pipcount(g->board,g,&mypip,&oppip);
sprintf(temp,"Total of your dice rolls = %-3d        Pips remaining = %-3d",
	Total,mypip);
mvwaddstr(statwin,row++,0,temp);
row++;
row++;

mvwaddstr(statwin,row++,0,"Opponent:");
mvwaddstr(statwin,row++,0,"---------");

row++;
mvwaddstr(statwin,row++,0,"Singles   1  2  3  4  5  6  Doubles   1  2  3  4  5  6");
temp[0] = '\0';
for (i = 0; i < 6; i++) {
	sprintf(temp, "%s%3d", temp, g->oprolls[i]);
	OpTotal += (g->oprolls[i] * (i+1));
	}
sprintf(temp, "%s          ",temp);
for (i = 0; i < 6; i++) {
	sprintf(temp, "%s%3d", temp, g->opdoubles[i]);
	OpTotal += (g->opdoubles[i] * (i+1) * 4);
	}

mvwaddstr(statwin,row++,8,temp);
row++;
sprintf(temp,"Total of opponent dice rolls = %-3d    Pips remaining = %-3d",
	OpTotal,oppip);
mvwaddstr(statwin,row++,0,temp);


mvwaddstr(statwin,23,16,"Press H for histogram or <return> to continue: ");

touchwin(statwin);		/* Make sure the screen is updated */
wrefresh(statwin);		/* update the window clearing screen */
c = wgetch(statwin) & 0x7f;	/* Wait for user response */

if (c == 'h' || c == 'H') {	/* Histogram wanted */
	wclear(statwin);		/* clear the window */

/*
 * Draw the axis themselves
 *
 */


	for (i = 2; i < 18; i++) {		/* Vertical axis */
		mvwaddstr(statwin,i,11,"|");
		mvwaddstr(statwin,i,44,"|");
		}

	for (i = 12; i < 41; i++) {		/* Horizontal axis */
		mvwaddstr(statwin,17,i,"-");
		mvwaddstr(statwin,17,i+33,"-");
		}

/*
 * Number the vertical axis
 *
 */

	mvwaddstr(statwin,2,8,"15");
	mvwaddstr(statwin,2,41,"15");

	mvwaddstr(statwin,7,8,"10");
	mvwaddstr(statwin,7,41,"10");

	mvwaddstr(statwin,12,9,"5");
	mvwaddstr(statwin,12,42,"5");

/*
 * Put the numbers across the bottom of the axis
 *
 */

	col = 13;
	for (i = 1; i < 7; i++) {
		sprintf(temp,"%d", i);
		mvwaddch(statwin,18,col,temp[0]);
		mvwaddch(statwin,18,col+33,temp[0]);
		col += 5;
		}

/*
 * Label the top and bottom of the graph
 *
 */

	mvwaddstr(statwin,0,17,"H i s t o g r a m   o f   D I C E   R o l l s");
	mvwaddstr(statwin,19,20,"S I N G L E S");
	mvwaddstr(statwin,19,53,"D O U B L E S");
	mvwaddstr(statwin,21,4,"Legend:");
	sprintf(temp,"X = You, dice total = %3d", Total);
	sprintf(temp,"%s     O = Opponent, dice total = %3d", temp, OpTotal);
	mvwaddstr(statwin,21,14,temp);
	wmove(statwin,22,23);
	wprintw(statwin,"pips       = %3d",mypip);
	wmove(statwin,22,58);
	wprintw(statwin,"pips       = %3d",oppip);

/*
 * Label the left side of the graph
 *
 */

	sprintf(temp,"Number");
	for (i = 0; i < strlen(temp); i++)
		mvwaddch(statwin,7+i,0,temp[i]);

	sprintf(temp,"of");
	for (i = 0; i < strlen(temp); i++)
		mvwaddch(statwin,9+i,3,temp[i]);

	sprintf(temp,"Occurrences");
	for (i = 0; i < strlen(temp); i++)
		mvwaddch(statwin,5+i,6,temp[i]);

/*
 * Now that we have the axis drawn and labeled, fill in the data
 *
 */

	for (dice = 0; dice < 6; dice++) {
		for (i = 0; i < 4; i++) {
			switch (i) {
			case 0:
				rolls = g->rolls[dice];
				col = 12 + dice * 5;
				c = 'X';
				break;
			case 1:
				rolls = g->oprolls[dice];
				col = 14 + dice * 5;
				c = 'O';
				break;
			case 2:
				rolls = g->doubles[dice];
				col = 45 + dice * 5;
				c = 'X';
				break;
			case 3:
				rolls = g->opdoubles[dice];
				col = 47 + dice * 5;
				c = 'O';
				break;
				}
	
/*
 * Special case.  If we have more than 30 of one roll, put a * at the
 * top of the second column and show 29 X's or O's.
 *
 */

			row = 16;
			if (rolls > 30) {
				rolls = 29;
				mvwaddch(statwin,2,col+1,'*');
				}

/*
 * While the roll counter is greater than zero, put out X's or O's.
 *
 */

			while (rolls > 0) {
				mvwaddch(statwin,row--,col,c);
				rolls--;
				if (row < 2) {	/* move to 2nd column */
					row = 16;
					col++;
					}
				}
			}
		}

/*
 * We are done with the graph.  Refresh and wait for a keypress
 *
 */

	mvwaddstr(statwin,23,25,"Press <return> to continue: ");
	touchwin(statwin);		/* Make sure the screen is updated */
	wrefresh(statwin);		/* update the window clearing screen */
	wgetch(statwin);		/* Wait for user response */
	}

wclear(statwin);		/* clear the window */
wrefresh(statwin);		/* update the window clearing screen */
delwin(statwin);		/* delete the window */
}
