/* dohelp.c		3/27/92
 *
 * Copyright 1992  Earle F. Ake
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 *
 * Original coding by Earle F. Ake <ake@dayton.saic.com> - 27 March 1992.
 *
 */

#include "ldb.h"

/*----------------------------------------------------------------------
 *	dohelp -- display online help for the user
 *
 * This function creates a new curses window and displays command help
 * to the user.  The user then presses any key to return to the game.
 *----------------------------------------------------------------------
 */

dohelp()
{
WINDOW *helpwin;
int row;

helpwin = newwin(0,0,0,0);	/* get a new window to post help to */

mvwaddstr(helpwin,0,30,"ldb Command Summary");		/* print title */
mvwaddstr(helpwin,1,30,"-------------------");		/* underline title */
row = 3;

if(GameState == STATE_MYACPT) {
	mvwaddstr(helpwin,row,0,"Accept -");
	mvwaddstr(helpwin,row++,15,"Accept the double and the game continues.");
	row++;
	mvwaddstr(helpwin,row,0,"Decline -");
	mvwaddstr(helpwin,row++,15,"You decline the double and lose the game for the current");
	mvwaddstr(helpwin,row++,15,"game value.");
	row++;
	}

if(GameState == STATE_CONTROL) {
	mvwaddstr(helpwin,row,0,"Invert -");
	mvwaddstr(helpwin,row++,15,"Invert the board for this game.  Pressing Invert again will");
	mvwaddstr(helpwin,row++,15,"put it back to normal.  Inverting the board does not affect");
	mvwaddstr(helpwin,row++,15,"point numbering.");
	row++;
	mvwaddstr(helpwin,row,0,"Resend -");
	mvwaddstr(helpwin,row++,15,"Resend your last move command to your opponent.");
	row++;
	mvwaddstr(helpwin,row,0,"Get Resend -");
	mvwaddstr(helpwin,row++,15,"Request a resend from your opponent.");
	row++;
	mvwaddstr(helpwin,row,0,"Screen Dump -");
	mvwaddstr(helpwin,row++,15,"Dump the screen to ldb_screen.dmp");
	row++;
	mvwaddstr(helpwin,row,0,"Delete Game -");
	mvwaddstr(helpwin,row++,15,"This marks a game for deletion.  The game is not deleted");
	mvwaddstr(helpwin,row++,15,"until you quit and you can undelete it by pressing D again.");
	row++;
	}

if(GameState == STATE_MYTURN) {
	mvwaddstr(helpwin,row,0,"Roll -");
	mvwaddstr(helpwin,row++,15,"Roll the dice.  Your roll will appear in your move block.");
	mvwaddstr(helpwin,row++,15,"You will see two numbers appear or four if you have");
	mvwaddstr(helpwin,row++,15,"rolled doubles.");
	row++;
	mvwaddstr(helpwin,row,0,"Double -");
	mvwaddstr(helpwin,row++,15,"Choose to double the current game value.  A message will");
	mvwaddstr(helpwin,row++,15,"be sent to your opponent and ldb then will automatically");
	mvwaddstr(helpwin,row++,15,"select roll.");
	row++;
	}

if(GameState == STATE_MYMOVE) {
	mvwaddstr(helpwin,row,0,"Point -");
	mvwaddstr(helpwin,row++,15,"Attempt to make the point your last move ended on.");
	row++;
	mvwaddstr(helpwin,row,0,"Off -");
	mvwaddstr(helpwin,row++,15,"Bear off a piece by using the next UNUSED roll.");
	row++;
	mvwaddstr(helpwin,row,0,"Reset -");
	mvwaddstr(helpwin,row++,15,"Reset your rolls to UNUSED and put the board back how it was");
	mvwaddstr(helpwin,row++,15,"before you moved.  You can then enter some different moves.");
	row++;
	mvwaddstr(helpwin,row,0,"Send -");
	mvwaddstr(helpwin,row++,15,"Send your move to your opponent.  You will be able to");
	mvwaddstr(helpwin,row++,15,"enter 2 lines of 56 characters to send with your move.");
	row++;
	}

if(GameState != STATE_CONTROL) {
	mvwaddstr(helpwin,row,0,"Board -");
	mvwaddstr(helpwin,row++,15,"Cycle between the current board, the board before your");
	mvwaddstr(helpwin,row++,15,"opponent's last move, and the board after your opponent's");
	mvwaddstr(helpwin,row++,15,"last move.");
	row++;
	}

if((GameState == STATE_MYTURN) || (GameState == STATE_MYMOVE)) {
	mvwaddstr(helpwin,row,0,"Concede -");
	mvwaddstr(helpwin,row++,15,"Concede the current game.");
	row++;
	}

mvwaddstr(helpwin,row,0,"Next Game -");
mvwaddstr(helpwin,row++,15,"The next game is displayed.  If there is no next game, quit.");
row++;
mvwaddstr(helpwin,row,0,"Quit -");
mvwaddstr(helpwin,row++,15,"Quit the current ldb session.");

mvwaddstr(helpwin,23,25,"Press <return> to continue: ");

touchwin(helpwin);		/* Make sure the screen is updated */
wrefresh(helpwin);		/* update the help window clearing screen */
wgetch(helpwin);		/* Wait for user response */
wclear(helpwin);		/* clear the help window */
wrefresh(helpwin);		/* update the help window clearing screen */
delwin(helpwin);		/* delete the help window */
}
