/*	vars.c		8/4/91
 *
 * Copyright 1991  Perry R. Ross
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 */

#include "ldb.h"

/*======================================================================
 * This file contains the definition for all global variables, as well
 * as the static initialization values for those that need it.
 *======================================================================
 */

int Pflag;			/* should I process local input? */
int Rflag;			/* should I look for mail? */
struct game *ghead;		/* head of linked list of games */
struct game *gtail;		/* tail of linked list of games */
struct legal *lhead;		/* head of list of legal moves */
struct legal *ltail;		/* tail of list of legal moves */
struct people *phead;		/* head of people list */
struct packet P;		/* last packet read */
char cr_mycolor;		/* my color when game is created */
char cr_opcolor;		/* opponent's color for new games */
char cr_mydir;			/* my direction for new games */
char *notify;			/* address to notify when game ends */
char blk76[] =			/* 76 blanks */
"                                                                            ";

char FeIsActive = 0;		/* has the front-end been initialized? */
char FeWaitInit = 0;		/* non-0 if message() has been called */

#ifdef NEED_READDIR
struct direct dirbuf;		/* mem used by readdir emulation #define */
#endif

int GameState = 0;		/* Current game state for help */
int boardnums[3] = {BD_AFTOP, BD_BEFOP, BD_CUR};
char *states[] = {		/* description of the states */
	"Waiting for opponent to start game",
	"Waiting for opponent to move",
	"Waiting for opponent to accept double",
	"Your turn (you haven't rolled yet)",
	"Your move (you have rolled)",
	"Waiting for you to accept double",
	"Game over"
	};

struct opt options[] = {
	"broadcast",	OPT_BCAST,	" [file]",
	"\tSend a mail message to all opponents",
	"colors",	OPT_COLOR,	" xx",
	"\t\tSet colors for new game",
	"control",	OPT_CONTROL,	"",
	"\t\tPerform control functions on games",
	"crawford",	OPT_CRAWFORD,	"",
	"\t\tEnable crawford rule for new games",
	"direction",	OPT_DIRECTION,	" dir",
	"\t\tSet direction for new game [up or down]",
	"european",	OPT_EUROPE,	"",
	"\t\tEnable european rule for new games",
	"help",		OPT_HELP,	"",
	"\t\t\tPrint this message",
	"jacoby",	OPT_JACOBY,	"",
	"\t\t\tEnable jacoby rule for new games",
	"match",	OPT_MATCH,	" number",
	"\t\tSet number of points in match",
	"myaddr",	OPT_MYADDR,	" addr",
	"\t\tSet local e-mail address",
	"notify",	OPT_NOTIFY,	" addr",
	"\t\tSend mail to addr when game ends",
	"permanent",	OPT_PERM,	"",
	"\t\tMake new games permanent",
	"play",		OPT_PLAY,	"",
	"\t\t\tPlay any waiting games but do not read mail",
	"read",		OPT_READ,	"",
	"\t\t\tRead incoming mail but do not play",
	"reconstruct",	OPT_RECONS,	" file",
	"\tReconstruct a game from opponent's data file",
	"remotestart",	OPT_RSTART,	" u1 u2",
	"\tStart a game between u1 and u2",
	"score",	OPT_SCORE,	"",
	"\t\t\tPrint cumulative score by opponent",
	"start",	OPT_START,	" user",
	"\t\tStart a game with another user",
	NULL,		-1,		NULL,		NULL
	};

char *opcodes[] = {
        "START", "USTART", "TIE",  "MOVE", "OFFERDOUBLE", "ACCEPTDOUBLE",
	"DECLINEDOUBLE", "CONCEDE", "REMOTESTART", "RESTART", "MSTART",
	"RESEND", "NOTIFY",
	NULL
        };

struct namevalue nv_rcfile[] = {
	"myname",	FT_STRING,	Offset(struct ldbrc *,myname),	NULL,
	"myaddr",	FT_STRING,	Offset(struct ldbrc *,myaddr),	NULL,
	"peoplefile",	FT_STRING,	Offset(struct ldbrc *,pfile),	NULL,
	"gamefile",	FT_STRING,	Offset(struct ldbrc *,gfile),	NULL,
	"backupfile",	FT_STRING,	Offset(struct ldbrc *,gbackup),	NULL,
	"mailfile",	FT_STRING,	Offset(struct ldbrc *,mfile),	NULL,
	"delmail",	FT_STRING,	Offset(struct ldbrc *,delmail),	NULL,
	"lockfile",	FT_STRING,	Offset(struct ldbrc *,lockfile),NULL,
	"sendcmd",	FT_STRING,	Offset(struct ldbrc *,sendcmd),	NULL,
	"tempfile",	FT_STRING,	Offset(struct ldbrc *,tempfile),NULL,
	"colors",	FT_STRING,	Offset(struct ldbrc *,defclrs),	NULL,
	"direction",	FT_STRING,	Offset(struct ldbrc *,defdir),	NULL,
	"initialboard",	FT_STRING,	Offset(struct ldbrc *,initboard),NULL,
	"autoroll",	FT_STRING,	Offset(struct ldbrc *,autoroll),NULL,
	"automove",	FT_STRING,	Offset(struct ldbrc *,automove),NULL,
	"autodouble",	FT_INT,		Offset(struct ldbrc *,autodouble),0,
	"supercmd",	FT_STRING,	Offset(struct ldbrc *,supercmd),NULL,
	"superkey",	FT_CHAR,	Offset(struct ldbrc *,superkey),0,
	"checkpoint",	FT_STRING,	Offset(struct ldbrc *,chkpt),	NULL,
	"timeout",	FT_INT,		Offset(struct ldbrc *,acctime),	0,
	"keepold",	FT_INT,		Offset(struct ldbrc *,keepold),	0,
	"debug",	FT_INT,		Offset(struct ldbrc *,debug),	0,
	NULL,		0,		-1,	0
	};

struct namevalue nv_gfile[] = {		/* extracts into global var G */
	"gameid",	FT_STRING,	Offset(struct game *,gameid),	NULL,
	"opaddr",	FT_STRING,	Offset(struct game *,opaddr),	NULL,
	"opname",	FT_STRING,	Offset(struct game *,opname),	NULL,
	"myaddr",	FT_STRING,	Offset(struct game *,myaddr),	NULL,
	"mycolor",	FT_CHAR,	Offset(struct game *,mycolor),	0,
	"opcolor",	FT_CHAR,	Offset(struct game *,opcolor),	0,
	"mydir",	FT_CHAR,	Offset(struct game *,mydir),	0,
	"opdir",	FT_CHAR,	Offset(struct game *,opdir),	0,
	"gameval",	FT_INT,		Offset(struct game *,gameval),	0,
	"flags",	FT_INT,		Offset(struct game *,flags),	0,
	"opversion",	FT_INT,		Offset(struct game *,opver),	0,
	"state",	FT_CHAR,	Offset(struct game *,state),	0,
	"term",		FT_CHAR,	Offset(struct game *,term),	0,
	"seq",		FT_INT,		Offset(struct game *,seq),	0,
	"lastop",	FT_STRLKUP,	Offset(struct game *,lastop),
		(int) opcodes,
	"mycmt",	FT_STRING,	Offset(struct game *,mycmt),	NULL,
	"mycmt2",	FT_STRING,	Offset(struct game *,mycmt2),	NULL,
	"opcmt",	FT_STRING,	Offset(struct game *,opcmt),	NULL,
	"opcmt2",	FT_STRING,	Offset(struct game *,opcmt2),	NULL,
	"dispmsg",	FT_STRING,	Offset(struct game *,dispmsg),	NULL,
	"opmvs0",	FT_MOVE,	Offset(struct game *,opmvs[0]),	0,
	"opmvs1",	FT_MOVE,	Offset(struct game *,opmvs[1]),	0,
	"opmvs2",	FT_MOVE,	Offset(struct game *,opmvs[2]),	0,
	"opmvs3",	FT_MOVE,	Offset(struct game *,opmvs[3]),	0,
	"blot0",	FT_CHAR,	Offset(struct game *,blot[0]),	0,
	"blot1",	FT_CHAR,	Offset(struct game *,blot[1]),	0,
	"blot2",	FT_CHAR,	Offset(struct game *,blot[2]),	0,
	"blot3",	FT_CHAR,	Offset(struct game *,blot[3]),	0,
	"mvs0",		FT_MOVE,	Offset(struct game *,mvs[0]),	0,
	"mvs1",		FT_MOVE,	Offset(struct game *,mvs[1]),	0,
	"mvs2",		FT_MOVE,	Offset(struct game *,mvs[2]),	0,
	"mvs3",		FT_MOVE,	Offset(struct game *,mvs[3]),	0,
	"maxused",	FT_INT,		Offset(struct game *,maxused),	0,
	"hiused",	FT_INT,		Offset(struct game *,hiused),	0,
	"adcnt",	FT_INT,		Offset(struct game *,adcnt),	0,
	"admax",	FT_INT,		Offset(struct game *,admax),	0,
	"opbd",		FT_BOARD,	Offset(struct game *,opbd[0]),	0,
	"mybd",		FT_BOARD,	Offset(struct game *,mybd[0]),	0,
	"board",	FT_BOARD,	Offset(struct game *,board[0]),	0,
	"curbd",	FT_CHAR,	Offset(struct game *,curbd),	-1,
	"rolls",	FT_INTARRAY,	Offset(struct game *,rolls[0]),	6,
	"doubles",	FT_INTARRAY,	Offset(struct game *,doubles[0]),6,
	"oprolls",	FT_INTARRAY, Offset(struct game *,oprolls[0]),	6,
	"opdoubles",	FT_INTARRAY, Offset(struct game *,opdoubles[0]),6,
	"starttime",	FT_TIME,	Offset(struct game *,starttime),0,
	"lastacc",	FT_TIME,	Offset(struct game *,lastacc),	0,
	"mcurrent",	FT_INTARRAY,	Offset(struct game *,mcurrent[0]),2,
	"mtotal",	FT_INT,		Offset(struct game *,mtotal),	0,
	"notify",	FT_STRING,	Offset(struct game *,notify),	NULL,
	"end",		FT_END,		-1,	0,
	NULL,		0,		-1,	0
	};

struct namevalue nv_packet[] = {
	"version",	FT_INT,		Offset(struct packet *,version),0,
	"timestamp",	FT_TIME,	Offset(struct packet *,timestamp),0,
	"gameid",	FT_STRING,	Offset(struct packet *,gameid),	NULL,
	"opcode",	FT_STRLKUP,	Offset(struct packet *,opcode),
		(int) opcodes,
	"move0",	FT_MOVE,	Offset(struct packet *,mvs[0]),	0,
	"move1",	FT_MOVE,	Offset(struct packet *,mvs[1]),	0,
	"move2",	FT_MOVE,	Offset(struct packet *,mvs[2]),	0,
	"move3",	FT_MOVE,	Offset(struct packet *,mvs[3]),	0,
	"name",		FT_STRING,	Offset(struct packet *,name),	NULL,
	"addr",		FT_STRING,	Offset(struct packet *,addr),	NULL,
	"comment",	FT_STRING,	Offset(struct packet *,comment),NULL,
	"comment2",	FT_STRING,	Offset(struct packet *,comment2),NULL,
	"seq",		FT_INT,		Offset(struct packet *,seq),	0,
	"colors",	FT_STRING,	Offset(struct packet *,colors),	NULL,
	"direction",	FT_STRING,	Offset(struct packet *,dir),	NULL,
	"autodouble",	FT_STRING,	Offset(struct packet *,autodbl),NULL,
	"jacoby",	FT_STRING,	Offset(struct packet *,jacoby), NULL,
	"crawford",	FT_STRING,	Offset(struct packet *,crawford),NULL,
	"european",	FT_STRING,	Offset(struct packet *,european),NULL,
	"permanent",	FT_STRING,	Offset(struct packet *,perm),	NULL,
	"match",	FT_STRING,	Offset(struct packet *,match),  NULL,
	"notify",	FT_STRING,	Offset(struct packet *,notify),	NULL,
	"end",		FT_END,		-1,	0,
	NULL,		0,		-1,	0
	};

struct namevalue nv_pfile[] = {
	"addr",		FT_STRING,	Offset(struct people *,addr),	NULL,
	"name",		FT_STRING,	Offset(struct people *,name),	NULL,
	"alias",	FT_STRING,	Offset(struct people *,alias),	NULL,
	"myaddr",	FT_STRING,	Offset(struct people *,myaddr),	NULL,
	"equiv",	FT_STRING,	Offset(struct people *,equiv),	NULL,
	"fence",	FT_TIME,	Offset(struct people *,fence),	0,
	"score",	FT_INTARRAY,	Offset(struct people *,score[0]), 10,
	"end",		FT_END,		-1,	0,
	NULL,		0,		-1,	0
	};

struct namevalue nv_pequiv[] = {
	"addr",		FT_STRING,	Offset(struct people *,addr),	NULL,
	"equiv",	FT_STRING,	Offset(struct people *,equiv),	NULL,
	"end",		FT_END,		-1,	0,
	NULL,		0,		-1,	0
	};

int (*func[OPSTATES][NOP])() = {
/*	START	USTART	TIE	MOVE	OFRDBL	ACPTDBL
		DECDBL	CONCEDE	RSTART	RESTART	MSTART	RESEND	NOTIFY	*/
	start,	istart,	tie,	opmove,	smerr,	smerr,
		smerr,	opconc,	smerr,	restart,mstart,	smerr,	smerr,
	smerr,	smerr,	smerr,	opmove,	opofr,	smerr,
		smerr,	opconc,	smerr,	smerr,	smerr,	smerr,	smerr,
	smerr,	smerr,	smerr,	smerr,	smerr,	opacpt,
		opdec,	opconc,	smerr,	smerr,	smerr,	smerr,	smerr
	};

char *rejlcl[] = {			/* reject messages for local player */
	"",					/* no error */
	"Move does not contain a legal roll.",	/* shouldn't happen */
	"You must fill your inner table before bearing off.",
	"There is no piece on that point.",
	"The destination of that move is occupied.",
	"You cannot move while you are on the bar.",
	"You can't move your opponent's pieces.",
	"You must bear that piece off with an exact roll."
	};

char *rejmsg[] = {		/* reject messages for received moves */
	"Move Accepted.",				/* no error */
	"Move does not contain a legal roll.",		/* bad roll */
	"Cannot remove pieces before filling inner table.",
	"There is no piece at the specified location.",
	"The destination of this move is occupied.",
	"Attempt to move while pieces are on the bar.",
	"Attempt to move wrong color.",
	"That piece must be borne off by an exact roll."
	};
