/*	t_email.c		9/5/91
 *
 * Copyright 1991  Perry R. Ross
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 */

#include "ldb.h"

/*======================================================================
 * This file is the e-mail transport for the ldb program.  It is
 * modularized to allow other transports to be substituted, most
 * notably a socket transport to allow interactive network backgammon.
 * For now, though, this is the only transport available.
 *
 * Packets are sent via TSendPacket, which takes an instance of
 * struct packet and an address, and sends the packet to that address.
 * TInitialize must be called before any calls to TSendPacket, and
 * TFinishSession must be called before exiting.
 *
 * Individual files may be sent by calling TSendFile.  These files
 * need not be related to a game.
 *======================================================================
 */

PRIVATE PStringSub();


/*----------------------------------------------------------------------
 *	TInitialize -- initialize the transport
 *
 * This function is called before the transport is used.  As you can
 * see, email doesn't require a great deal of initialization.
 *----------------------------------------------------------------------
 */

TInitialize()
{
}


/*----------------------------------------------------------------------
 *	FeDrawMenu -- draw menu choices in menu box
 *
 * This function closes down the transport.
 *----------------------------------------------------------------------
 */

TFinishSession()
{
}



/*----------------------------------------------------------------------
 *	TSendPacket -- send a packet to an email address
 *
 * This function sends a packet to an email address.  It returns 1 if
 * the packet was sent, 0 if an error occurred.
 *----------------------------------------------------------------------
 */

TSendPacket(p,addr)
struct packet *p;
char *addr;
{
char subject[80];
FILE *fp;
int status;


if ((fp = fopen(rc.tempfile,"w")) == NULL) {	/* open temp file */
	message("ERROR: can't create %s!\n",rc.tempfile);
	return;
	}
fprintf(fp,"<<<===LDB===>>>\n");	/* send magic header text */
nvwrite(fp,nv_packet,p);	/* write the contents of the packet */
fclose(fp);				/* close temp file */
sprintf(subject,"<=LDB=> from %s (Long Distance Backgammon)", rc.myname);
status = TSendFile(addr,rc.tempfile,subject);	/* send the file */
unlink(rc.tempfile);		/* delete the temp file */
return(status);
}


/*----------------------------------------------------------------------
 *	TSendFile -- send a file to an address
 *
 * This function takes an e-mail address, a file, and a subject line,
 * and sends the contents of the file to the specified address.  The
 * subject is set to the contents of the subject argument, which should
 * be one line.  TSendFile returns a 1 if the message was sent,
 * and a 0 if an error occurred.
 *----------------------------------------------------------------------
 */

TSendFile(addr,file,subj)
char *addr, *file, *subj;
{
char cmd[256];
char *subs[3];
int s;

subs[0] = addr;			/* substitute $a with opponent address */
subs[1] = file;			/* substitue $f with file */
subs[2] = subj;			/* substitute $s with subject */
PStringSub(rc.sendcmd,"afs",subs,cmd);
s = system(cmd);			/* execute email command */
return(s == SYS_GOOD);
}



/*----------------------------------------------------------------------
 *	PStringSub -- substitute variables in a string
 *
 * This function copies str to obuf, replacing occurrences of $x to
 * a corresponding string.  The characters which can appear after
 * the $ are passed in a single string in the "chars" argument, and
 * the strings to replace them with are passed, in the same order as
 * the characters appear in "chars", in the "strings" argument.
 *----------------------------------------------------------------------
 */

PRIVATE PStringSub(str,chars,strings,obuf)
char *str, *chars, *strings[], obuf[];
{
char *s, *o, *t;

for (s = str, o = obuf; *s; s++) {
	if (*s != '$') {	/* as long as we don't see a $ */
		*o++ = *s;	/* just keep copying */
		continue;
		}
	s++;
	if (*s == '$') {	/* $$ is a single $ */
		*o++ = '$';
		continue;
		}
	if ( (t = strchr(chars,*s)) == NULL)	/* skip invalid $ subs */
		continue;
	t = strings[t - chars];		/* get ptr to replacement string */
	while (*t)			/* copy it to obuf */
		*o++ = *t++;
	}
*o = '\0';				/* null terminate obuf */
}
