/* board.c		8/3/91
 *
 * Copyright 1991  Perry R. Ross
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, subject to the restrictions
 * detailed in the README file, which is included here by reference.
 * Any other use requires written permission from the author.  This software
 * is distributed "as is" without any warranty, including any implied
 * warranties of merchantability or fitness for a particular purpose.
 * The author shall not be liable for any damages resulting from the
 * use of this software.  By using this software, the user agrees
 * to these terms.
 */

#include "ldb.h"

/*----------------------------------------------------------------------
 *	newboard -- set up a board array for a new game
 *
 * This function initializes a board array so that it is set up
 * properly for a new game.  It is passed two characters that are
 * used to draw the pieces for the board.  C1 is the color for the
 * upbound player, and c2 is the color for the downbound player.
 *----------------------------------------------------------------------
 */

newboard(b,c1,c2)
board b;
char c1, c2;
{
int i;

for (i = 0; i < BOARDSIZE; i++) {
	b[i].qty = 0;			/* init to empty */
	b[i].color = '-';		/* init to invalid color */
	}
b[1].qty = 2;				/* 2 c1's on 1 point */
b[1].color = c1;
b[6].qty = 5;				/* 5 c2's on 6 point */
b[6].color = c2;
b[8].qty = 3;				/* 3 c2's on 8 point */
b[8].color = c2;
b[12].qty = 5;				/* 5 c1's on 12 point */
b[12].color = c1;
b[13].qty = 5;				/* 5 c2's on 13 point */
b[13].color = c2;
b[17].qty = 3;				/* 3 c1's on 17 point */
b[17].color = c1;
b[19].qty = 5;				/* 5 c1's on 19 point */
b[19].color = c1;
b[24].qty = 2;				/* 2 c2's on 24 point */
b[24].color = c2;
}


/*----------------------------------------------------------------------
 *	copyboard -- make a copy a board array
 *
 * This is a convenience function that copies an entire board. The
 * source is given as "f", and the destination as "t".
 *----------------------------------------------------------------------
 */

copyboard(f,t)
board f, t;
{
int i;

for (i = 0; i < BOARDSIZE; i++)
	t[i] = f[i];
}
