/*
 * $Header$
 *
 * $Log$
 *
 */
#include <stdio.h>
#include "sect.h"
#include "util.h"
#include "empire.h"

/*
   This program moves military into sectors where you expect che to be
   present.  It uses a dumpfile as input to describe the country and a
   file containing a list of sectors where that you think suffer from che
*/


/*
 * This is mmvr, a tool for automatically redistributing civs for
 * BSD-empire.  People are warned that use of this tool can devestate 
 * an empire country in a matter of a couple of updates, and so it
 * must be used carefully
 *
 * This software was written by King Craig (AKA Craig Chase) who
 * makes no warranty as to the worth or correctness of this software.
 * Use it at your own risk.
 *
 * This software may be freely distributed as long as the name(s) of
 * the author(s) remain attached.
 */



FILE *outfile, *fopen();
FILE *specfile;

#define MAX_PATH_LENGTH 80


struct tpathstr {
  char path[MAX_PATH_LENGTH];
  int cost;
  int length;
  sctlst_t  *sct;
} *t_vec; /* an array of the paths to move everywhere */

int maxpath = 10;
int maxcost = 1000;
int max_coms = 100; /* maximum number of commands which can be produced 
		       (i.e. set it low if you don't want to spend all
		       your BTUs) */
int enlmil = 100; /* minimum number of military to leave in an enlistment
                     center */


#define FALSE 0
#define TRUE 1


struct adminstr {
  int id;
  int che;
  int mil; /* positive means surpluss of mil, negative means deficit */
  sctlst_t *snext; /* next for one of the special lists */
};

/* country is the complete list of the whole country */
sctlst_t  *country, *read_dump();
int c_size; /* number of sectors in the country */

/* optimize is not currently implemented */
int optimize = FALSE; /* flag which, when set, instructs pmvr to attempt 
			 to opimize the moves it generates */

int *mov_cost; /* this pointer is used to implement the matrix of costs to 
		 move from anywhere to everywhere.  The sector id is 
		 used as the index.  The size of the matrix is 
		 c_size X c_size */

int minforce = 10; /* the size of the minimum number of troops in a
                      sector with che */
int ratio = 10; /* the percentage of troops relative to number of civs */

sctlst_t *slist = NULL; /* list of sectors with surpluss mil */
sctlst_t *dlist = NULL; /* list of sectors with a defecit of mil */
sctlst_t *hlist = NULL; /* list of roads (use for mobility) */

main(argc,argv)
int argc;
char **argv;
{
  char output_file[80];
  char dump_file[80];
  char che_file[80];
  char special_file[80];
  sctlst_t  *manage;

  strcpy(output_file,"-");
  strcpy(dump_file,"dump");
  strcpy(che_file,"che");
  strcpy(special_file,"special");

  /* read in args */
  while(argc > 1) {
    if (argv[1][0] == '-')
      switch(argv[1][1]) {
      case 'o': /* output file arg */
	argc--; argv++;
	strcpy(output_file,argv[1]);
	break;
      case 'd': /* dump file arg */
	argc--; argv++;
	strcpy(dump_file,argv[1]);
	break;
      case 'c': /* che file arg */
	argc--; argv++;
	strcpy(che_file,argv[1]);
	break;
      case 's': /* special file arg */
	argc--; argv++;
	strcpy(special_file,argv[1]);
	break;
      case 'P':
	argc--; argv++;
	sscanf(argv[1],"%d",&maxpath);
	if (maxpath > MAX_PATH_LENGTH || maxpath < 0)
	  maxpath = MAX_PATH_LENGTH;
	break;
      case 'N': /* max number of moves */
	argc--; argv++;
	sscanf(argv[1],"%d",&max_coms);
	break;
      default:
	fprintf(stderr,
		"USAGE: mmvr [-o outfile ] [-d dumpfile] [-c chefile]");
	fprintf(stderr," [-P maxpath]");
	exit(1);
      }
    argc--;
    argv++;
  }
  
  if (0 == strcmp(output_file,"-"))
    outfile = stdout;
  else
    if (NULL == (outfile = fopen(output_file,"w"))) {
      fprintf(stderr,"cannot open %s for output\n",output_file);
      exit(1);
    }

  country = read_dump(dump_file);
  init_country();
  load_che(che_file);
  load_special(special_file);
  admin(country);

  fclose(outfile);
}


init_country()
{
  int i;
  sctlst_t  *p;

  c_size = 0;
  for (p = country; p != NULL; p = p->next,c_size++) {
    p->spec.p = NEW(struct adminstr);
    ((struct adminstr *) p->spec.p)->id = c_size;
    ((struct adminstr *) p->spec.p)->che = 0;
    ((struct adminstr *) p->spec.p)->mil = 0;
  }
  t_vec = NEWN(struct tpathstr, c_size);
  
  for (i = 0,p = country; i < c_size; i++, p = p->next)
    t_vec[i].sct = p;
    
#ifdef DEBUG
  fprintf(stderr,"%d sectors read from file\n",c_size);
#endif
}

load_special(char* fname)
{
  FILE *fp,*fopen();
  char in_line[80];
  int x,y;
  int mil;
  sctlst_t  *p;
  struct adminstr * p_spec;

  if (NULL == (fp = fopen(fname,"r"))) {
    fprintf(stderr,"Cannot open %s for input\n",fname);
    exit(1);
  }

  /* first set up the values for the normal sectors */
  for (p = country; p; p = p->next) {
    p_spec = (struct adminstr *) p->spec.p;
    p_spec->mil = p->data->coms[MIL] - target_mil(p);
  }


  while(NULL != fgets(in_line,80,fp)) {
    sscanf(in_line,"%d,%d %d", &x, &y, &mil);
    for (p = country; p != NULL; p = p->next) 
      if (p->data->sct_x == x && p->data->sct_y == y) {
        p_spec = (struct adminstr *) p->spec.p;
        p_spec->mil = p->data->coms[MIL] - mil;
      }
  }
}



/* load the list of che sectors from file */
load_che(fname)
char *fname;
{
  FILE *fp,*fopen();
  char in_line[80];
  int x,y;
  int che;
  int mil;
  sctlst_t  *p;
  struct adminstr * p_spec;

  if (NULL == (fp = fopen(fname,"r"))) {
    fprintf(stderr,"Cannot open %s for input\n",fname);
    exit(1);
  }

  while(NULL != fgets(in_line,80,fp)) {
    sscanf(in_line,"%d,%d %d", &x, &y, &che);
    for (p = country; p != NULL; p = p->next) 
      if (p->data->sct_x == x && p->data->sct_y == y) {
        p_spec = (struct adminstr *) p->spec.p;
        p_spec->che = che;
      }
  }
}



/*
  try to move military from s to d.  The number which should be moved
  is MIN(surpluss in s, defecit in d).
  Use mobility in highways if at all possible
  return the number of military actually moved
*/  
int move_em(sctlst_t *s, sctlst_t *d)
{
  int d_id; 
  int bestcost;
  sctlst_t *h; /* a highway */
  sctlst_t *besth; /* best highway */
  int cost;
  struct adminstr *sspec, *dspec, *hspec;
  int num;
  
  
  sspec = s->spec.p;
  dspec = d->spec.p;
  /* find the best highway to use */
  bestcost = maxcost;
  for (h = hlist; h; h = ((struct adminstr *)h->spec.p)->snext) {
    hspec = h->spec.p;
    cost = -1;

    if (mov_cost[sspec->id * c_size + hspec->id] >= 0) {
      cost = mov_cost[sspec->id * c_size + hspec->id];
      if (mov_cost[hspec->id * c_size + dspec->id] >= 0)
        cost += mov_cost[hspec->id * c_size + dspec->id];
      else
        cost = -1;
    }

    if (cost >= 0 && cost < bestcost) {
      bestcost = cost;
      besth = h;
    }
  }

  if (bestcost >= 0 && bestcost < maxcost) {
    hspec = besth->spec.p;

    num = sspec->mil;
    if (mov_cost[sspec->id * c_size + hspec->id] != 0)
      num = MIN(num, (500 * s->data->sct_mobil) /
                mov_cost[sspec->id * c_size + hspec->id]);
    
    num = MIN(num, -dspec->mil);
    if (mov_cost[hspec->id * c_size + dspec->id] != 0)
      num = MIN(num, (500 * besth->data->sct_mobil) /
                mov_cost[hspec->id * c_size + dspec->id]);
    
    if (num > 0) {
      if (s != besth)
        emit_move(s, besth, num);
      if (besth != d)
        emit_move(besth, d, num);
    }
    return num;
  }
  else
    return 0;
}
      
/* move num mil from src to dst */
emit_move(sctlst_t *s, sctlst_t *d, int num)
{
  int s_id, d_id;
  
  make_tree(s);
  d_id = ((struct adminstr *)d->spec.p)->id;

#ifdef DEBUG
  if (t_vec[d_id].cost < 0) {
    fprintf(stderr,"SHIT!!!!! I'm trying to do the impossible!\n");
    fprintf(stderr,"trying to move from %d,%d to %d,%d\n",
	    s->data->sct_x,s->data->sct_y,d->data->sct_x,d->data->sct_y);
  }
  else {
    fprintf(stderr,"trying to move from %d,%d to %d,%d\n",
	    s->data->sct_x,s->data->sct_y,d->data->sct_x,d->data->sct_y);
  }

#endif

  fprintf(outfile,"mov mil %d,%d %d v%sv\n",s->data->sct_x,s->data->sct_y,
	  num,t_vec[d_id].path);
  fprintf(outfile,"h\n");

  s->data->sct_mobil -= (int) (0.9999 + 
			       num * ((float) t_vec[d_id].cost) / 500 );
  s->data->coms[MIL] -= num;
  d->data->coms[MIL] += num;
}


int target_mil(sctlst_t *s)
{
  struct adminstr* spec;
  int mil;

  spec = s->spec.p;

  mil = 0;
  if (spec->che || s->data->sct_loyal == '*' || s->data->coms[CIV] == 0)
    mil = MAX(minforce, (ratio * s->data->coms[CIV]) / 100 + 1);
  if (s->data->sct_type == 'e' && s->data->sct_effic > 60)
    mil = MAX(mil, enlmil);

  return mil;
}

/* decide who to move where */
admin(sctlst_t *lst)
{
  int s_id,d_id;
  int movs = 0; /* number of mov commands generated so far */
  int *cost; /* a pointer int the mov cost array should always be
	       such that *cost <==> mov_cost[s_id][d_id] */
  sctlst_t *sect; /* loop counter for sectors */
  struct adminstr *s, *d;
  int mil;
  sctlst_t *src, *dst;
  

  find_paths();

  /* find surpluss and deficient sectors */
  for (sect = lst; sect; sect = sect->next) {
    s = sect->spec.p;
    if (0 > s->mil) { /* deficit */
      s->snext = dlist;
      dlist = sect;
    }
    else if (0 < s->mil) { /* surpluss */
      s->snext = slist;
      slist = sect;
    }
  }
  
  /* find highways with mobility */
  for (sect = lst; sect; sect = sect->next) {
    if (sect->data->sct_type == '+' && sect->data->sct_mobil > 0) {
      s = sect->spec.p;
      s->snext = hlist;
      hlist = sect;
    }
  }
  
  
  /* put mil in each def sector */
  movs = 0;
  for (dst = dlist; dst; dst = ((struct adminstr *)dst->spec.p)->snext) {

    if (!slist)
      break;
    d = dst->spec.p;

    /* check each potential source */
    for (src = slist;
         src && d->mil < 0;
         src = ((struct adminstr *)src->spec.p)->snext) {
    
      mil = move_em(src, dst);
      if (mil > 0) { /* succeeded in moving some */
        d->mil += mil;
        s = src->spec.p;
        s->mil -= mil;
        movs += 1;
        if (movs > max_coms) /* exit now! */
          return;
      }
    }
    if (d->mil < 0) 
      fprintf(stderr, "could not get enough mil into sector %d,%d\n",
              dst->data->sct_x, dst->data->sct_y);
  }
}

/* find good paths between every pair of sectors in the country */
/* for storage reasons, only the cost is recorded for moving between */
/* the sectors */
find_paths()
{
  sctlst_t  *src;
  int s_id; /* the id of the source sector */
  int i,j;
  int *ptr;


  mov_cost = NEWN(int, c_size * c_size);

  /* it is assumed that the list pointed to by 'country' is ordered
     by id nums */

  for (src = country; src != NULL; src = src->next) {
    make_tree(src);
    s_id = ((struct adminstr *) src->spec.p)->id;
    ptr = mov_cost + s_id * c_size;
    for (i = 0; i < c_size; i++) 
      *ptr++ = t_vec[i].cost;
  }
}


/* set the t_vec array to hold paths from the root node for all sectors */
/* whose ids are greater than that of the root */
make_tree(root)
sctlst_t  *root; /* a point on the tree */
{
  int root_id;
  int s_id,d_id;
  int i;
  int thislength;
  int thiscost;
  sctlst_t  *todo; /* the list of sectors to visit */
  sctlst_t  *tail; /* the last sector in the todo list */
  static char pathdir[7]="yujnbg";
  char incpath[2]; /* incremental path */
  struct sctstr *sct;

  root_id = ((struct adminstr *) root->spec.p)->id;
  /* initialize the tree */
  for (i = 0; i < c_size; i++) {
    t_vec[i].cost = -1;
    t_vec[i].length = -1;
    strcpy(t_vec[i].path,"");
  }
  t_vec[root_id].cost = 0;
  t_vec[root_id].length = 0;
  strcpy(t_vec[root_id].path,"");

  /* make the root node the only thing on the tree */
  root->aux = NULL;
  todo = root;
  tail = root;
  
  /* build the tree */
  for (; todo != NULL; todo = todo->aux) {
    s_id = ((struct adminstr *) todo->spec.p)->id;
    thislength = t_vec[s_id].length + 1;
    if (thislength <= maxpath) {
      for (i = 0; i < 6; i++) {
	if (todo->neighbor[i] != NULL) {
	  d_id = ((struct adminstr *)todo->neighbor[i]->spec.p)->id;
	  sct = todo->neighbor[i]->data;
	  thiscost = t_vec[s_id].cost + COST(sct);
	  if (thiscost < maxcost) {
	    if (t_vec[d_id].cost < 0) {
	      /* add it to the tree and put it on the todo list */
	      t_vec[d_id].cost = thiscost;
	      t_vec[d_id].length = thislength;
	      incpath[0] = pathdir[i];
	      incpath[1] = '\0';
	      strcpy(t_vec[d_id].path,t_vec[s_id].path);
	      strcat(t_vec[d_id].path,incpath);
	      tail->aux = todo->neighbor[i];
	      todo->neighbor[i]->aux = NULL;
	      tail = todo->neighbor[i];
	    }
	    else if (t_vec[d_id].cost > thiscost ||
		     (t_vec[d_id].cost == thiscost && 
		      t_vec[d_id].length > thislength)) {
	      /* we've found a better path, make it so */
	      t_vec[d_id].cost = thiscost;
	      t_vec[d_id].length = thislength;
	      incpath[0] = pathdir[i];
	      incpath[1] = '\0';
	      strcpy(t_vec[d_id].path,t_vec[s_id].path);
	      strcat(t_vec[d_id].path,incpath);
	    }
	  }
	}
      }
    }
  }
}

