#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "sect.h"
#include "ver.h"

FILE *outfile, *fopen(), *verfile;
struct ver_info *ver;

#define MAXLINE 128     /* Input line from version */
struct ver_info *read_ver ()
{
  /* Stuff to determine food consumption */
  float d, rate, rate2, fcrate, obrate, uwbrate, eatrate, babyeat, fgrate, etu, bankinterest, civtax, uwtax,activemil, reservmil;
  char buf[MAXLINE];

  /* Check the version to find out about growth and stuff */
  if ((verfile = fopen("ver", "r")) == NULL)
  {     fprintf(stderr, "Can't open version file \"ver\" for reading.\n");
	fclose(outfile);
	exit(1);
  }
  ver = (struct ver_info *)malloc(sizeof(struct ver_info));

  while (fgets(buf, MAXLINE, verfile) != NULL)
  {
	if (sscanf(buf, "An update consists of %f empire", &d) == 1)
		etu = d;
	if (sscanf(buf, "A non-aggi, 100 fertility sector can grow %f food per etu", &d) == 1)
		fgrate = d;
	if (sscanf(buf, "%f civilians will harvest %f food per etu", &d, &rate) == 2)
		fcrate = rate / d;
	if (sscanf(buf, "%f civilians will give birth to %f babies", &d, &rate) == 2)
		obrate = rate / d;
	if (sscanf(buf, "%f uncompensated workers will give birth to %f babies", &d, &rate) == 2)
		uwbrate = rate / d;
	if (sscanf(buf, "In one time unit, %f people eat %f units", &d, &rate) == 2)
		eatrate = rate / d;
	if (sscanf(buf, "%f babies eat %f units", &d, &rate) == 2)
		babyeat = rate / d;
	if (sscanf(buf, "Banks pay $%f in interest per %f gold", &rate, &d) == 2)
		bankinterest = rate / d;
	if (sscanf(buf, "%f civilians generate $%f, uncompensated workers $%f each", &d, &rate, &rate2) == 3 )
		{
			civtax = rate / d;
			uwtax = rate2 / d;
		}
	if (sscanf(buf, "%f active military cost $%f, reserves cost $%f", &d, &rate, &rate2) == 3 )
		{
			activemil = -rate / d;
			reservmil = -rate2 / d;
		}
  }
  fclose(verfile);
  ver->fcrate = fcrate;
  ver->obrate = obrate;
  ver->uwbrate = uwbrate;
  ver->eatrate = eatrate;
  ver->babyeat = babyeat;
  ver->etu = etu;
  ver->fgrate = fgrate;
  ver->bankinterest = bankinterest;
  ver->civtax = civtax;
  ver->uwtax = uwtax;
  ver->activemil = activemil;
  ver->reservmil = reservmil;
return (ver);
}
