/****************************************************************
*  function: mobcalc
*
*  puts a float into mobcost that represents the cost of moving
*  1 civilian along the path given by arguments.
*
****************************************************************/

#include "sve.h"

extern struct Secdata *Sector;
extern struct maptype Map[XWIDTH][YHEIGHT];
extern char Direction[6];


mobcalc(x, y, path, mobcost)
int x;
int y;
char *path;
float *mobcost;
{
  int dir;
  int secnum;

  *mobcost = 0;
  while (*path != '\0')
    {
      for (dir=0; Direction[dir] != *path; dir++)
	;
      translocate(dir, x, y, &x, &y);

      secnum = Map[x][y].secnumber;

      if ((Map[x][y].designation == '+') || (Map[x][y].designation == '='))
	*mobcost += 0.1 * (100 - Sector[secnum].Census.Eff) / 100;
      else if (Map[x][y].designation == '^')
	*mobcost += 4.0;
      else if (Map[x][y].designation == '-')
	*mobcost += 0.4;
      else 
	*mobcost += 0.2;
      path++;
    }
}
