#include <stdio.h>
#include <string.h>
#include "sve.h"

#define HEADER 4		/* no. of lines to skip in header of 'dump' */
#define MAXLINE 512
#define SEPS " "

/*****************************************************************/
/*  function: getdump                                            */
/*                                                               */
/*  reads input from a file generated by empire's "dump" command */
/*  argument given to getdump is a pointer to a file             */
/*                                                               */
/*  puts data into an array of Secdata structures, for global    */
/*  use by the SVE empire tools                                  */
/*                                                               */
/*****************************************************************/


struct Secdata *Sector;

#ifdef DRIVER
main()
{
  printf("Entering the function. \n");
  getdump("dump");
  printf("Leaving the function. \n");
}
#endif

getdump(name)
char *name;
{
  int lines = 0;
  int i = 0;
  FILE *fp, *fopen();
  char buffer[MAXLINE];
  int j;
  char temp[5];

  if ((fp = fopen(name, "r")) == NULL)
    {
      printf("Nonexistent data file: %s \n", name);
      exit(0);
    }

  while (fgets(buffer, MAXLINE, fp) != NULL)	/* count lines in data file */
    lines++;
  lines = lines - HEADER;
  fclose(fp);

  fp = fopen(name, "r");	/* reopen data file, to read it */

				/* allocate space for sector structures */
  Sector = (struct Secdata *)malloc(sizeof(struct Secdata) * (lines+2));
  if (Sector == NULL)
    {
      printf("Out of memory error in sector allocation. Exit. \n");
      exit(1);
    }

				/* skip HEADER lines */
  for (j=0; j < HEADER; j++)
    fgets(buffer, MAXLINE, fp);

				/* get array of sector structures */
				/* skip last line! It contains something */
				/* like "560 sectors", not data!  */
  for (i=0; i < (lines-1); i++)
    {
      fgets(buffer, MAXLINE, fp);

      Sector[i].Census.X = atoi(strtok(buffer, SEPS));
      Sector[i].Census.Y = atoi(strtok(NULL, SEPS));
      strcpy(temp, strtok(NULL, SEPS));
      Sector[i].Census.Des = temp[0];
      strcpy(temp, strtok(NULL, SEPS));
      Sector[i].Census.Sdes = temp[0];
      Sector[i].Census.Eff = atoi(strtok(NULL, SEPS));
      Sector[i].Census.Mob = atoi(strtok(NULL, SEPS));
      strcpy(temp, strtok(NULL, SEPS));
      Sector[i].Census.Occupied = temp[0];
      Sector[i].Resource.Min = atoi(strtok(NULL, SEPS));
      Sector[i].Resource.Gold = atoi(strtok(NULL, SEPS));
      Sector[i].Resource.Fert = atoi(strtok(NULL, SEPS));
      Sector[i].Resource.Ocontent = atoi(strtok(NULL, SEPS));
      Sector[i].Resource.Uran = atoi(strtok(NULL, SEPS));
      Sector[i].Census.Work = atoi(strtok(NULL, SEPS));
      Sector[i].Census.Avail = atoi(strtok(NULL, SEPS));
      Sector[i].Census.Terr = atoi(strtok(NULL, SEPS));
      Sector[i].Census.Civ = atoi(strtok(NULL, SEPS));
      Sector[i].Census.Mil = atoi(strtok(NULL, SEPS));
      for (j=0; j < 12; j++)
	     Sector[i].Commod.Comm[j] = atoi(strtok(NULL, SEPS));
      for (j=0; j < 12; j++)
	     {
	       strcpy(temp, strtok(NULL, SEPS));
	       Sector[i].Commod.Deliver[j] = temp[0];
	     }
      for (j=0; j < 12; j++)
	Sector[i].Commod.Cut[j] = atoi(strtok(NULL, SEPS));
      strcpy(Sector[i].Level.Dist_path, (strtok(NULL, SEPS)));
      Sector[i].Level.Dist_x = atoi(strtok(NULL, SEPS));
      Sector[i].Level.Dist_y = atoi(strtok(NULL, SEPS));
      for (j=0; j < 12; j++)
	Sector[i].Level.Dist[j] = atoi(strtok(NULL, SEPS));
	  
    }


  fclose(fp);
  return(lines-1);
}

