/****************************************************************
* program: accountant
*
* takes standard input from the empire command "production"
*
* summarizes gain/loss of each commodity for each warehouse,
* and outputs a table to stdout
*
* designed for use as a pipe: i.e. type "prod #0 | accountant"
* when in empire; it will require a reasonably current dump to
* assign each sector to the proper warehouse
*
* No options enabled in this incarnation
****************************************************************/

#include "sve.h"
#include <stdio.h>
#include <string.h>

#define MAXLINE 256

#define MAXFIELD 12
#define SEPS " \t"

int make[16];
int use[16];

main()
{
  int i;
  char *buffer;
  char *field[16];	/* buffer broken into <= 16 separate fields */
  int fieldcount;
  char *tempfield;
  char sectype;

  extern int make[16];
  extern int use[16];

  buffer = (char *) malloc (MAXLINE);
  for (i=0; i < 16; i++)
    field[i] = (char *) malloc (MAXFIELD);
  tempfield = (char *) malloc (MAXFIELD);

  for (i=0; i < 16; i++)	/* set counters to zero */
    make[i] = use[i] = 0;
      
  for (i=0; i < 4; i++)		/* strip off header; 4 lines */
    gets(buffer);

  while (gets(buffer) != NULL)
    {
      tempfield = strtok(buffer, SEPS);
      fieldcount = 1;
      while((tempfield = strtok(NULL, SEPS)) != NULL)
	{
	  strcpy(field[fieldcount], tempfield);
	  fieldcount++;
	  
	  if (fieldcount > 15)	/* check for overflow error */
	    break;
	}

      if (fieldcount < 3)	/* ignore last line of prod */
	break;

      sectype = field[1][0];

      switch (sectype) 
	{
	case 'a':
	  make[0] += atoi(field[4]);
	  break;

	case 'o':
	  make[7] += atoi(field[4]);
	  break;

	case 'g':
	  make[5] += atoi(field[4]);
	  break;

	case 'm':
	  make[4] += atoi(field[4]);
	  break;

	case 'u':
	  make[10] += atoi(field[4]);
	  break;

	case 'i':
	  make[1] += atoi(field[4]);
	  use[8] += atoi(field[8]);
	  use[9] += atoi(field[9]);
	  break;

	case 'd':
	  make[2] += atoi(field[4]);
	  use[7] += atoi(field[8]);
	  use[8] += atoi(field[9]);
	  use[9] += atoi(field[10]);
	  break;

	case '%':
	  make[3] += atoi(field[4]);
	  use[7] += atoi(field[8]);
	  break;

	case 'b':
	  make[6] += atoi(field[4]);
	  use[5] += atoi(field[8]);
	  break;

	case 'j':
	  make[8] += atoi(field[4]);
	  use[4] += atoi(field[8]);
	  break;

	case 'k':
	  make[9] += atoi(field[4]);
	  use[4] += atoi(field[8]);
	  break;

	case 't':
	  make[11] += atoi(field[4]);
	  use[5] += atoi(field[8]);
	  use[7] += atoi(field[9]);
	  use[8] += atoi(field[10]);
	  break;

	case 'r':
	  make[12] += atoi(field[4]);
	  use[5] += atoi(field[8]);
	  use[7] += atoi(field[9]);
	  use[8] += atoi(field[10]);
	  break;

	case 'e':
	  make[13] += atoi(field[4]);
	  break;

	case 'l':
	  make[14] += atoi(field[4]);
	  use[8] += atoi(field[8]);
	  break;

	case 'p':
	  make[15] += atoi(field[4]);
	  use[8] += atoi(field[8]);
	  break;

	default:
	  break;
	}

    }

  printf("Production Accountant: summary\n");
  printf("COMMODITY      MAKE     USE     NET CHANGE \n");
  show("iron",4);
  show("dust",5);
  show("oil",7);
  show("lcm",8);
  show("hcm",9);

}

show(commodity, index)
char *commodity;
int index;
{
  extern int make[];
  extern int use[];

  printf("%-15s %-9.0d %-8.0d %-10.0d \n", commodity, make[index],
	 use[index], (make[index] - use[index]));

}
