#!/bin/awk -f
#
#	Makes three columns from a play list for posting.
#	The play list format is:  Country names
#	are in the first 24 characters, then the password.  Email address
#	starts at character 41.  I kept leaving countries out and putting
#	some in twice when I did this by hand. -harmless
#

function truncwhite(str,  i,j) {
  for (i=1;i<=length(str) && substr(str,i,1) ~ "[ \t\r\n]";i++) ;
  for (j=length(str);j>i && substr(str,j,1) ~ "[ \t\r\n]";j--) ;
  return (substr(str,i,j-i+1));
}


{
  name=truncwhite(substr($0,1,24));

  if (n%3 == 0) printf("\n  ");
  printf("  %-20s",name);
  n++;
}

END {
  printf("\n");
}
