#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/nxtsct.c,v 1.4 89/07/02 20:55:17 mr-frog Exp $";
#endif

/*
 * nxtsct.c
 *
 * select/get the next sector from a range of sectors.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"

/*
 * get the next sector in the range
 * that matches the conditions.
 */
struct sctstr *
nxtsctp(np)
        register struct nstr_sect *np;
{
        while (1) {
                np->dx++;
                np->x++;
                if (np->x >= WORLD_X)
                        np->x = 0;
                if (np->dx >= np->range.width) {
                        np->dx = 0;
                        np->x = np->range.lx;
                        np->dy++;
                        if (np->dy >= np->range.height)
                                return (struct sctstr *)0;
                        np->y++;
                        if (np->y >= WORLD_Y)
                                np->y = 0;
                }
                if ((np->y + np->x) & 01)
                        continue;
                if (np->type == NS_DIST) {
                        np->curdist = mapdist(np->x, np->y, np->cx, np->cy);
                        if (np->curdist > np->dist)
                                continue;
                }
                return(getsectp(np->x, np->y));
        }
        /*NOTREACHED*/
}
