#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/update/RCS/age.c,v 1.2 89/07/02 20:45:25 mr-frog Exp $";
#endif

/*
 * age.c
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "nat.h"
#include "file.h"

age_levels(etu)
	int	etu;
{
	extern	float	level_age_rate;
	register float best_tech;
	register float best_res;
	register struct natstr *np;
	int	i;
	double	level;
	double	delta;
	int	deltares;

	best_tech = 0.0;
	best_res = 0.0;
	for (i=0; np = getnatp(i); i++) {
		if ((np->nat_stat & STAT_NORM) == 0)
			continue;
/* No tech leak from Diety countries - Jeff Bailey (bailey@mcs.kent.edu) */
		if (np->nat_stat & STAT_GOD)
			continue;
		/*
		 * age levels by 1% per every 48 etus
		 */
		if (best_tech < np->nat_level[NAT_TLEV])
			best_tech = np->nat_level[NAT_TLEV];
		if (best_res < np->nat_level[NAT_RLEV])
			best_res = np->nat_level[NAT_RLEV];
		if (level_age_rate != 0.0) {
			delta = np->nat_level[NAT_RLEV] * etu /
				(100 * level_age_rate);
			np->nat_level[NAT_RLEV] -= delta;
			delta = np->nat_level[NAT_TLEV] * etu /
				(100 * level_age_rate);
			np->nat_level[NAT_TLEV] -= delta;
		}
		/*
		 * age reserves by 1% per every 24 etus
		 */
		deltares = -roundavg(np->nat_reserve * etu / 2400.0);
		if (deltares != 0)
			np->nat_reserve += deltares;
		/* Chad Zabel - above number is negative ( was a -= there
		which was wrong. */
	}
	best_tech /= 5;
	best_res /= 5;
	for (i=0; np = getnatp(i); i++) {
		if ((np->nat_stat & STAT_INUSE) == 0)
			continue;
		level = np->nat_level[NAT_TLEV];
		if (level < best_tech && chance(0.2))
			np->nat_level[NAT_TLEV] += (best_tech - level) / 3;
		level = np->nat_level[NAT_RLEV];
		if (level < best_res && chance(0.2))
			np->nat_level[NAT_RLEV] += (best_res - level) / 3;
	}
}
