#ifndef lint
static char *RCSid = "$Header: /net/midway/a/mr-frog/empire/CS3.4/lib/subs/RCS/wire.c,v 1.1 1994/08/21 06:29:04 mr-frog Exp $";
#endif

/*
 * wire.c
 *
 * write a announcement to a user from another.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include <fcntl.h>
#include <sys/uio.h>
#include "nat.h"
#include "tel.h"
#include "file.h"


int
typed_wire(from, to, message, type)
	natid	from;
	natid	to;
	s_char	*message;
	int	type;
{
	register s_char *bp;
	int	len;
	struct	telstr tel;
	struct	natstr *np;
	struct	iovec iov[2];
	int	fd;
	s_char	buf[1024];

	if ((np = getnatp(to)) == 0 ||
		((np->nat_stat & STAT_NORM) == 0 &&
		(np->nat_stat & STAT_SANCT) == 0))
		return 0;
	if ((fd = open(wirebox(buf, to), O_WRONLY|O_APPEND, 0)) < 0) {
		logerror("telegram 'open' of %s (#%d) failed",
			wirebox(buf, to), to);
		return 0;
	}
	tel.tel_from = from;
	(void) time(&tel.tel_date);
	bp = message;
	while (*bp++)
		;
	len = bp - message;
	if (len >= MAXTELSIZE)
		len = MAXTELSIZE;
	message[len] = 0;
	tel.tel_length = len;
	tel.tel_type = type;
	iov[0].iov_base = (caddr_t) &tel;
	iov[0].iov_len = sizeof(tel);
	iov[1].iov_base = message;
	iov[1].iov_len = len;
	if (writev(fd, iov, 2) < iov[0].iov_len + iov[1].iov_len) {
		logerror("telegram 'write' to #%d failed", to);
	} else {
		np->nat_ann++;
		/* don't do putnat because of expense */
	}
	(void) close(fd);
	return 0;
}
