#ifndef lint
static char *RCSid = "$Header: empdis.c,v 1.16 90/03/19 10:54:05 mr-frog Exp $";
#endif /* not lint */

/*
 * empdis.c
 *
 * empire dispatcher stuff
 *
 * from PSL Empire, 1985
 */

#include <stdio.h>
#include "misc.h"
#include "player.h"
#include "nat.h"
#include "tel.h"
#include "proto.h"
#include "com.h"
#include "deity.h"
#include "keyword.h"
#include "file.h"
#include "io.h"

#include <fcntl.h>
#include <sys/time.h>
#include <signal.h>

int
getcommand(combufp)
	s_char	*combufp;
{
	struct	natstr *natp;
	s_char	buf[512];

	natp = getnatp(player->cnum);
	do {
		prprompt(natp->nat_minused, natp->nat_btu);
		*buf = 0;
		if (recvclient(buf, sizeof(buf)) < 0)
			return -1;
	} while (*buf == 0);
	copy(buf, combufp);
	return (strlen(combufp));
}

explain()
{
	extern struct comstr player_coms[];
	register s_char *format;
	register int i;

	pr("\t\tCurrent EMPIRE Command List\n");
	pr("\t\t------- ------ ------- ----\n");
	pr("Initial number is cost in B.T.U. units.\n");
	pr("Next 2 chars (if present) are:\n");
	pr("$ - must be non-broke\tc -- must have capitol\n");
	pr("Args in [brackets] are optional.\n");
	if (player->nstat > 4) {
		pr("All-caps args in <angle brackets>");
		pr(" have the following meanings:\n");
		pr("  <NUM> :: a number in unspecified units\n");
		pr("  <COMM> :: a commodity such as `food', `guns', etc\n");
		pr("  <VAR> :: a commodity such as `food', `guns', etc\n");
		pr("  <TYPE> :: an item type such as `ship', `plane', etc\n");
	}
	for (i = 0; (format = player_coms[i].c_form) != 0; i++) {
		if ((player_coms[i].c_permit & player->ncomstat) == player_coms[i].c_permit){
			pr("%d ", player_coms[i].c_cost);
			if ((player_coms[i].c_permit & MONEY) == MONEY)
			    pr("$");
			else
			    pr(" ");
			if ((player_coms[i].c_permit & CAP) == CAP)
			    pr("c");
			else
			    pr(" ");
			pr(" %s\n", format);
		}
	}
	pr("For further info on command syntax see \"info syntax\".\n");
	return RET_OK;
}

/*
 * returns true if down
 */
int
gamedown()
{
	extern	s_char downfil[];
	int	downf;
	struct	telstr tgm;
	s_char	buf[512];

	if (player->god)
		return 0;
	if ((downf = open(downfil, O_RDONLY, 0)) < 0)
		return 0;
	if (read(downf, (s_char *) &tgm, sizeof(tgm)) != sizeof(tgm)) {
		logerror("bad header on login message (downfil)");
		close(downf);
		return 1;
	}
	if (read(downf, buf, tgm.tel_length) != tgm.tel_length) {
		logerror("bad length %d on login message", tgm.tel_length);
		close(downf);
		return 1;
	}
	if (tgm.tel_length >= sizeof(buf))
		tgm.tel_length = sizeof(buf)-1;
	buf[tgm.tel_length] = 0;
	pr(buf);
	pr("\nThe game is down\n");
	(void) close(downf);
	return 1;
}

daychange(now)
	time_t	now;
{
	struct	natstr *natp;
	struct	tm *tm;

	natp = getnatp(player->cnum);
	tm = localtime(&now);
	if ((tm->tm_yday % 128) != natp->nat_dayno) {
		natp->nat_dayno = tm->tm_yday % 128;
		natp->nat_minused = 0;
	}
}

getconstants()
{
	extern	int adj_update;
	extern	int etu_per_update;
	extern	int s_p_etu;
	s_char	*bp;
#ifdef BLITZ

	if (bp = kw_find("blitz_time"))
		kw_parse(CF_VALUE, bp, &player->blitz_time);
#endif /* BLITZ */
	if (bp = kw_find("adj_update"))
		kw_parse(CF_VALUE, bp, &adj_update);
	if (bp = kw_find("etu_per_update"))
		kw_parse(CF_VALUE, bp, &etu_per_update);
	if (bp = kw_find("s_p_etu"))
		kw_parse(CF_VALUE, bp, &s_p_etu);
}

int
getminleft(now, hour, mpd)
	time_t	now;
	int	*hour;
	int	*mpd;
{
	s_char	*bp;
	struct	tm *tm;
	int	nminleft;
	int	curtime;
	struct	natstr *natp;
	int	n;

	tm = localtime(&now);
	curtime = tm->tm_min + tm->tm_hour * 60;
	if (bp = kw_find("minutes"))
		kw_parse(CF_VALUE, bp, mpd);
	natp = getnatp(player->cnum);
	nminleft = *mpd - natp->nat_minused;
	if (bp = kw_find("hours")) {
		/*
		 * assume hours has already been set; just verify
		 * that it is present
		 */
		n = hour[1] - curtime;
		if (n < nminleft)
			nminleft = n;
	}
	n = 60*24 - (tm->tm_min + tm->tm_hour*60);
	if (n < nminleft)
		nminleft = n;
	return nminleft;
}
