/*
 * arch.c
 *
 * architecture-dependent process context code
 *
 */

#include "lwp.h"
#include "lwpint.h"

#if defined(BSD386)
void lwpInitContext(newp, sp)
	struct lwpProc *newp;
	void *sp;
{
	newp->context[2] = (int)sp;
	newp->context[0] = (int)lwpEntryPoint;
}

#elif defined(LINUX)

void lwpInitContext(newp, sp)
	struct lwpProc *newp;
	void	*sp;
{
	newp->context->__jmpbuf->__sp = sp;
	newp->context->__jmpbuf->__bp = sp;
	newp->context->__jmpbuf->__pc = (void *)lwpEntryPoint;
}

#elif defined(MIPS)

/*
 * fake setjmp() and longjmp() because builtin longjmp() checks the stack.
 */
static int jmpresult;

int lwpSave(jb)
	jmp_buf jb;
{
	jmpresult = 0;
	/* save context */
	asm ("sw	$31, 8($4)");	/* return address */
	asm ("sw	$30, 4($4)");	/* frame pointer */
	asm ("sw	$sp, 0($4)");	/* stack pointer */
	asm ("sd	$16, 12($4)");	/* callee save registers */
	asm ("sd	$18, 20($4)");
	asm ("sd	$20, 28($4)");
	asm ("sd	$22, 36($4)");
	return (jmpresult);
}

void lwpRestore(jb)
	jmp_buf jb;
{
	jmpresult = 1;
	/* restore context */
	asm ("lw	$sp, 0($4)");
	asm ("lw	$30, 4($4)");
	asm ("lw	$31, 8($4)");

	asm ("ld	$16, 12($4)");
	asm ("ld	$18, 20($4)");
	asm ("ld	$20, 28($4)");
	asm ("ld	$22, 36($4)");
}

void lwpInitContext(newp, sp)
	struct lwpProc *newp;
	void *sp;
{
	newp->context[1] = (int)sp;
	newp->context[2] = (int)lwpEntryPoint;
}

#elif defined(SUN3)

void lwpInitContext(newp, sp)
	struct lwpProc *newp;
	void	*sp;
{
	newp->context[2] = (int)sp;
	newp->context[3] = (int)lwpEntryPoint;
}

#elif defined(SUN4)

void lwpInitContext(newp, sp)
	struct lwpProc *newp;
	void		*sp;
{
	static jmp_buf *cpp;
	extern struct lwpProc *LwpCurrent;

	bzero(newp->context, sizeof(newp->context));
	newp->context[0] = (int)sp;
	/* preserve cpp for new context */
	cpp = &newp->context;
	if (!_setjmp(LwpCurrent->context)) {
		/* create new context */		
		/* flush registers */
		asm ("ta	0x03");
		/* %o0 <- newp */
		asm ("ld	[%fp+0x44], %o0");
		/* %o1 <- newp->context[0] */
		asm ("ld	[%o0], %o1");
		/* create min frame on new stack */
		asm ("save	%o1,-96, %sp");
		if (!_setjmp(cpp))
			_longjmp(LwpCurrent->context);
		lwpEntryPoint();
	}
}

#elif defined(__USLC__) && defined(i386)

/* USL/Unixware on an Intel 386/486/... processor.
 * Tested on Unixware v1.1.2, based on SYSV R4.2
 */

/* As per normal empire documentation, there is none.
 *
 * But, what we are attempting to do here is set up a longjump
 * context buffer so that the lwpEntryPoint is called when
 * the thread starts.
 *
 * I.E., what a setjmp/longjmp call set would do.
 *
 * How to figure this out?  Well, without the setjmp code, you
 * need to reverse engineer it by printing out the context buffer
 * and the processor registers, and mapping which ones need
 * to be set.
 *
 * Alternatively, you can single instruction step through the longjmp
 * function, and figure out the offsets that it uses.
 *
 * Using offsets in bytes,
 * context + 0x04 [1] -> esi  (general purpose reg)
 * context + 0x08 [2] -> edi  (general purpose reg)
 * context + 0x0C [3] -> ebp  (general purpose or parameter passing)
 * context + 0x10 [4] -> esp  (stack)
 * context + 0x14 [5] -> jump location for return
 */

void lwpInitContext(newp, sp)
	struct lwpProc *newp;
	void	*sp;
{
	newp->context[4] = (int)sp;
	newp->context[5] = (int)lwpEntryPoint;
}

#endif
