#ifndef lint
static char *RCSid = "$Header: trad.c,v 1.13 90/03/19 11:14:20 mr-frog Exp $";
#endif /* not lint */

/*
 * trad.c
 *
 * buy units from other nations.
 *
 * Dave Pare, 1986
 */

#include <ctype.h>
#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "item.h"
#include "ship.h"
#include "land.h"
#include "nuke.h"
#include "plane.h"
#include "trade.h"
#include "deity.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

/*
 * format: trade
 */
trad()
{
	struct	sctstr sect;
	struct	natstr *natp;
	int	lotno;
	float	price;
	coord	sx, sy;
	int	n;
	s_char	*p;
	int	saveid;
	struct	nstr_item ni;
	struct	trdstr trade;
	union	trdgenstr tg;
	int	plflags;
	extern	double tradetax;
	s_char	buf[1024];

	pr("\n     Empire Trade Report\n  ");
	prdate();
	if (commread() < 0) {
		pr("Unable to read commodity file; get help!\n");
		return RET_SYS;
	}
	n = 0;
	pr(" lot# player->cnum    country   price              desc\n");
	snxtitem_all(&ni, EF_TRADE);
	while (nxtitem(&ni, (s_char *)&trade)) {
		if (trade.trd_unitid < 0)
			continue;
		if (!trade_getitem(&trade, &tg)) {
			continue;
		};
		/* fix up database if things get weird */
		if (trade.trd_owner != tg.gen.trg_own) {
			trade.trd_unitid = -1;
			(void) puttrade(ni.cur, &trade);
			continue;
		}
		pr(" %3d ", ni.cur);
		(void) trade_desc(&trade, &tg);		/* XXX */
		if (trade.trd_owner == player->cnum && !player->god)
			pr(" (your own lot)\n");
		else
			pr("\n");
		n++;
	}
	if (n == 0) {
		pr("Nothing to buy at the moment...\n");
		return RET_OK;
	}
	if ((p = getstring("Which lot to buy : ", buf)) == 0 || *p == 0)
		return RET_OK;
	if (isdigit(*p) == 0)
		return RET_OK;
	lotno = atoi(p);
	if (lotno < 0 || lotno >= ni.cur) {
		pr("Bad lot number\n");
		return RET_OK;
	}
	if (!gettrade(lotno, &trade)) {
		pr("No such lot number\n");
		return RET_OK;
	}
	if (!trade_getitem(&trade, &tg)) {
		pr("Can't find trade #%d!\n", trade.trd_unitid);
		trade.trd_unitid = -1;
		if (!puttrade(lotno, &trade)) {
			pr("Couldn't save after getitem failed; get help!\n");
			return RET_SYS;
		}
		return RET_OK;
	}
	switch (trade.trd_type) {
	case EF_NUKE:
		if (!getsect(tg.gen.trg_x, tg.gen.trg_y, &sect)) {
			return RET_FAIL;
		}
		trade.trd_owner = sect.sct_own;
		break;
	case EF_PLANE:
	case EF_SHIP:
	case EF_LAND:
		break;
	default:
		pr("Bad unit type on lot number %d\n", lotno);
		return RET_FAIL;
	}
	if (trade.trd_owner == player->cnum) {
		pr("You can't buy from yourself!\n");
		return RET_OK;
	}
	price = multread(trade.trd_owner, player->cnum) * trade.trd_price;
	natp = getnatp(player->cnum);
	if (natp->nat_money < price) {
		pr("You don't have %.2f to spend!\n", price);
		return RET_OK;
	}
	/*
	 * Find the destination sector for the plane before the trade
	 * is actually made. Must be owned (except for satellites) and
	 * must be a 60% airfield (except for VTOL planes).
	 */
	if (((trade.trd_type == EF_PLANE) || (trade.trd_type == EF_NUKE))
	    && ((trade.trd_type == EF_NUKE) ||
				!(tg.pln.pln_flags & PLN_LAUNCHED))) {
		plflags = plchr[tg.pln.pln_type].pl_flags;
		while (1) {
			p = getstring("Destination sector: ", buf);
			if (p == 0) {
				return RET_FAIL;
			}
			if (!sarg_xy(p, &sx, &sy) ||
					!getsect(sx, sy, &sect)) {
				pr("Bad sector designation; try again!\n");
				continue;
			}
			if (!player->owner && !(plflags & P_O)) {
				pr("You don't own that sector; try again!\n");
				continue;
			}
			if (!(plflags & (P_V | P_O))) {
				if (!player->god && (sect.sct_type != SCT_AIRPT)) {
					pr(
				    "Destination sector is not an airfield!\n");
					continue;
				}
				if (!player->god && (sect.sct_effic < 60))  {
					pr(
				    "That airport still under construction!\n");
					continue;
				}
			}
			break;
		}
	}
	if (trade.trd_type == EF_LAND){
		while (1) {
			p = getstring("Destination sector: ", buf);
			if (p == 0) {
				return RET_FAIL;
			}
			if (!sarg_xy(p, &sx, &sy) ||
					!getsect(sx, sy, &sect)) {
				pr("Bad sector designation; try again!\n");
				continue;
			}
			if (!player->owner && !(plflags & P_O)) {
				pr("You don't own that sector; try again!\n");
				continue;
			}
			if (!player->god && (sect.sct_type != SCT_HEADQ)) {
				pr("Destination sector is not a headquarters!\n");
				continue;
			}
			if (!player->god && (sect.sct_effic < 60))  {
				pr("That headquarters still under construction!\n");
				continue;
			}
			break;
		}
	}
	saveid = trade.trd_unitid;
	trade.trd_unitid = -1;
	if (!puttrade(lotno, &trade)) {
		pr("Couldn't save trade after purchase; get help!\n");
		return RET_SYS;
	}
	pr("Bought %s %d for %.2f\n", trade_nameof(&trade, &tg),
		saveid, price);
	switch (trade.trd_type) {
	case EF_NUKE:
		while (1) {
			p = getstring("Destination sector: ", buf);
			if (p == 0) {
				return RET_FAIL;
			}
			if (!sarg_xy(p, &sx, &sy)) {
				pr("Bad sector designation; try again!\n");
				continue;
			}
			break;
		}
		tg.nuk.nuk_x =  sx;
		tg.nuk.nuk_y =  sy;
		tg.nuk.nuk_own = player->cnum;
		break;
	case EF_PLANE:
		if ((tg.pln.pln_flags & PLN_LAUNCHED) == 0) {
			tg.pln.pln_x = sx;
			tg.pln.pln_y = sy;
			if (tg.pln.pln_effic > 75)
				tg.pln.pln_effic = 75;
		}
#ifdef PLIMIT
		if (tg.pln.pln_ship >= 0){
			struct shpstr ship;
			getship(tg.pln.pln_ship, &ship);
			take_plane_off_ship(&tg.pln,&ship);
		}
#endif /* PLIMIT */
		tg.pln.pln_own = player->cnum;
		tg.pln.pln_wing = ' ';
		/* no cheap version of fly */
		tg.pln.pln_mobil = 0;
		tg.pln.pln_mission = 0;
		tg.pln.pln_ship = -1;
		break;
	case EF_LAND:
		tg.lnd.lnd_x = sx;
		tg.lnd.lnd_y = sy;
		if (tg.lnd.lnd_effic > 75)
			tg.lnd.lnd_effic = 75;

		if (tg.lnd.lnd_ship >= 0){
			struct shpstr ship;
			getship(tg.lnd.lnd_ship, &ship);
			ship.shp_nland--;
			putship(ship.shp_uid,&ship);
		}
		tg.lnd.lnd_own = player->cnum;
		tg.lnd.lnd_army = ' ';
		/* no cheap version of fly */
		tg.lnd.lnd_mobil = 0;
		tg.lnd.lnd_mission = 0;
		tg.lnd.lnd_ship = (-1);
		break;
	case EF_SHIP:
		tg.shp.shp_mission = 0;
		takeover_ship(&tg.shp, player->cnum, 0);
		break;
	default:
		pr("Bad trade type %d in trade\n", trade.trd_type);
		break;
	}
	if (!ef_write(trade.trd_type, saveid, (s_char *)&tg)) {
		pr("Couldn't write unit to disk; seek help.\n");
		return RET_SYS;
	}
	natp = getnatp(trade.trd_owner);
	natp->nat_money += roundavg(price * tradetax);
	putnat(natp);
	nreport(trade.trd_owner, N_MAKE_SALE, player->cnum, 1);
	wu(0, trade.trd_owner, "%s bought a %s #%d from you for $%.2f\n",
		cname(player->cnum), trade_nameof(&trade, &tg), saveid, price *
		tradetax);
	player->dolcost += price;
	return RET_OK;
}
