#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/show.c,v 1.7 89/09/17 17:12:21 mr-frog Exp $";
#endif

/*
 * show - give info on empire internal data structures - e.g.
 * 	planes, boats, nukes etc.
 *
 * Julian Onions, 1988
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "file.h"
#include "deity.h"

extern	int show_nuke_build();
extern	int show_nuke_stats();
extern	int show_nuke_capab();
extern	int show_plane_build();
extern	int show_plane_stats();
extern	int show_plane_capab();
extern	int show_ship_build();
extern	int show_ship_stats();
extern	int show_ship_capab();
extern	int show_sect_build();
extern	int show_sect_stats();
extern	int show_sect_capab();
extern	int show_land_build();
extern	int show_land_stats();
extern	int show_land_capab();

show()
{
	s_char   *p;
	int     (*cfunc)();
	int     (*sfunc)();
	int	(*bfunc)();
	struct	natstr *natp;
	int	tlev;
	s_char	buf[1024];
#ifdef DRNUKE
	extern	float drnuke_const;
	int	rlev;
#endif /* DRNUKE */

	p = getstarg(player->argp[1], "Describe what (plane, nuke, bridge, ship, sect, land unit)? ", buf);

	natp = getnatp (player->cnum);
	tlev = (int) (1.25 * natp->nat_level[NAT_TLEV]);
#ifdef DRNUKE
	rlev = (int) (1.25 * natp->nat_level[NAT_RLEV]);
#endif /* DRNUKE */
	if (player->god){
		tlev = 99999;
#ifdef DRNUKE
		rlev = 99999;
#endif /* DRNUKE */
	}
	switch (*p) {
	case 'b':
		show_bridge(99999);
		return RET_OK;
	case 'n':
#ifdef DRNUKE
		tlev = ((rlev/drnuke_const) > tlev ? tlev : (rlev/drnuke_const));
#endif /* DRNUKE */
		bfunc = show_nuke_build;
		cfunc = show_nuke_capab;
		sfunc = show_nuke_stats;
		break;
	case 'l':
		bfunc = show_land_build;
		sfunc = show_land_stats;
		cfunc = show_land_capab;
		break;
	case 'p':
		bfunc = show_plane_build;
		sfunc = show_plane_stats;
		cfunc = show_plane_capab;
		break;
	case 's':
		if (*(p+1) == 'e'){
			bfunc = show_sect_build;
			sfunc = show_sect_stats;
			cfunc = show_sect_capab;
		}else{
			bfunc = show_ship_build;
			sfunc = show_ship_stats;
			cfunc = show_ship_capab;
		}
		break;
	default:
		return RET_SYN;
	}
	p = getstarg(player->argp[2], "Build, stats, or capability data (b,s,c)? ", buf);
	if (*p == 'B' || *p == 'b')
		(*bfunc) (tlev);
	else if (*p == 'C' || *p == 'c')
		(*cfunc) (tlev);
	else if (*p == 'S' || *p == 's')
		(*sfunc) (tlev);
	return RET_OK;
}
