#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/plan.c,v 1.11 89/08/09 07:12:58 jeffw Exp $";
#endif

/*
 * plan.c
 *
 * Do a "plane report" (like ships report)
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "nsc.h"
#include "nuke.h"
#include "file.h"
#include "nat.h"
#include "deity.h"

plan()
{
	int nplanes;
	struct nstr_item np;
	struct plnstr plane;

	if (!snxtitem(&np, EF_PLANE, player->argp[1]))
		return RET_SYN;
	nplanes = 0;
	while (nxtitem(&np, (s_char *)&plane)) {
		if (!player->owner || plane.pln_own == 0)
			continue;
		if (nplanes++ == 0) {
			if (player->god)
				pr("own ");
#ifdef	ORBIT
			pr("   #    type                x,y    w  eff  mu att def tech ran hard   s/l L S nuke\n");
#else
			pr("   #    type                x,y    w  eff  mu att def tech ran hard   s/l nuke\n");
#endif	ORBIT
		}
		if (player->god)
			pr("%3d ", plane.pln_own);
		pr("%4d %-19.19s ", np.cur, plchr[plane.pln_type].pl_name);
		prxy("%4d,%-4d", plane.pln_x, plane.pln_y, player->cnum);
		pr(" %c %3d%% %3d %3d %3d  %3d %3d  %3d",
			plane.pln_wing, plane.pln_effic,
			plane.pln_mobil, plane.pln_att,
			plane.pln_def, plane.pln_tech,
			plane.pln_range, plane.pln_harden);
		if (plane.pln_ship >= 0)
			pr("%5dS", plane.pln_ship);
		else
		if (plane.pln_land >= 0)
			pr("%5dL", plane.pln_land);
		else
			pr("     ");
#ifdef	ORBIT
		if ((plchr[plane.pln_type].pl_flags & (P_O|P_M)) == P_O) {
			pr(" %c", (plane.pln_flags & PLN_LAUNCHED) ? 'Y' :
				'N');
			pr(" %c", (plane.pln_flags & PLN_SYNCHRONOUS) ?
				'Y' : 'N');
		}
		else
			pr("    ");
#endif	ORBIT
		if (plane.pln_nukeamt > 0)
			pr(" %1d %9.9s\n", plane.pln_nukeamt,
			       nchr[plane.pln_nuketype].n_name);
		else
			pr("\n");
	}

	if (nplanes == 0) {
		if (player->argp[1])
			pr("%s: No plane(s)\n", player->argp[1]);
		else
			pr("%s: No plane(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d plane%s\n", nplanes, splur(nplanes));

	return RET_OK;
}
