#ifndef lint
static char *RCSid = "$Header: path.c,v 1.12 89/09/02 02:36:16 mr-frog Exp $";
#endif

/*
 * path.c
 *
 * Show empire distribution paths.
 *
 * David Muir Sharnoff, 1986
 * Re-written 1989
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"
#include "sect.h"
#include "path.h"
#include "map.h"
#include "deity.h"

int
path()
{

	struct	nstr_sect ns;
	struct	natstr	*natp;
	struct	range	absrange;
	struct	range	relrange;
	struct	sctstr	sect, dsect;
	coord	cx, cy;
	int     i;
	int	y;
	s_char	*pp, *p, *BestDistPath();
	s_char	map[WORLD_Y][MAPWIDTH(3)];
	double	move_cost;
	s_char	buf[1024];

	if (!(p = getstarg(player->argp[1], "from sector : ", buf)) ||
	    !sarg_xy(p, &cx, &cy) ||
	    !getsect(cx, cy, &sect))
		return RET_SYN;
	if ((sect.sct_own != player->cnum) && !player->god){
		pr("Not yours\n");
		return RET_FAIL;
	}
	getsect(sect.sct_dist_x,sect.sct_dist_y,&dsect);
	pp = BestDistPath(buf, &sect,&dsect,&move_cost);
	if (pp == (s_char *)0){
		pr("No path possible from %s to distribution sector %s\n",
			xyas(sect.sct_x,sect.sct_y,player->cnum),
			xyas(dsect.sct_x,dsect.sct_y,player->cnum));
		return RET_FAIL;
	}
	pathrange(cx, cy, pp, 1, &absrange);
	snxtsct_area(&ns, &absrange);
	natp = getnatp(player->cnum);
	xyrelrange(natp, &absrange, &relrange);
	blankfill((s_char *)map, &ns.range, 3);
	while (*pp && (i = chkdir(*pp, DIR_STOP, DIR_LAST)) >= 0) {
		bcopy(routech[i][0], &map[deltay(cy, ns.range.ly)]
					 [deltax(cx, ns.range.lx)*2], 3);
		cx += diroff[i][0];
		cy += diroff[i][1];
		++pp;
	}
	border(&relrange, "     ", " ");
	while (nxtsct(&ns, &sect)) {
		if (!player->owner)
			continue;
		map[ns.dy][ns.dx*2+1] = dchr[sect.sct_type].d_mnem;
	}
	for (y=ns.range.ly, i=0; i < ns.range.height; y++, i++) {
		cy = yrel(natp, y);
		pr("%4d %s %-4d\n", cy, map[i], cy);
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&relrange, "     ", " ");
	return RET_OK;
}
