#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/decl.c,v 1.4 89/05/29 14:18:29 emp-src Exp $";
#endif /* not lint */

/*
 * decl.c
 *
 * declare war, neutrality or alliance.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "deity.h"

decl()
{
	register s_char *p;
	struct	natstr	*natp;
	int	rel;
	int	oldrel;
	int	n;
#ifdef SLOW_WAR
	int	theirrel;
	extern int	War_Cost;
#endif /* SLOW_WAR */
	natid	with, who;
	s_char	buf[1024];

	p = getstarg(player->argp[1], "alliance, neutrality, hostility, or war? ", buf);
	switch (*p) {
	case 'a':
		rel = ALLIED;
		break;
	case 'h':
		rel = HOSTILE;
		break;
#ifdef SLOW_WAR
	case 'm':
		if (!player->god) return RET_SYN;
		rel = MOBILIZATION;
		break;
	case 's':
		if (!player->god) return RET_SYN;
		rel = SITZKRIEG;
		break;
#endif /* SLOW_WAR */
	case 'n':
		rel = NEUTRAL;
		break;
	case 'w':
		rel = AT_WAR;
		break;
	default:
		pr("That's no declaration!\n");
		return RET_SYN;
	}
	if ((n = natarg(player->argp[2], "with which country? ")) < 0)
		return RET_SYN;
	with = n;
	who = player->cnum;
	if (player->god){
		n = natarg(player->argp[3], "for which country? ");
		if (n < 0)
			who = player->cnum;
		else
			who = n;
	}

	if (with == player->cnum){
		pr("What's the point!?!\n");
		return RET_FAIL;
	}
	natp = getnatp(who);

	if ((oldrel = getrel(natp, with)) == rel) {
		pr("No change required for that!\n");
		return RET_FAIL;
	}
#ifndef SLOW_WAR
	setrel(who, with, rel);
#endif /* SLOW_WAR */
	if (rel == ALLIED) {
		pr("Congratulations.\n");
		nreport(who, N_DECL_ALLY, with, 1);
		if((getrejects(who, getnatp(with)) & REJ_TELE) == 0)
		wu(0, with,
			"Country %s (#%d) has declared an alliance with you!\n",
				cname(who), who);
	} else if (rel == NEUTRAL) {
		if (oldrel == 1)
			nreport(who, N_DIS_ALLY, with, 1);
		else
			nreport(who, N_DIS_WAR, with, 1);
		pr("Neutrality declared.\n");
		if((getrejects(who, getnatp(with)) & REJ_TELE) == 0)
		wu(0, with,
			"Country %s (#%d) has declared neutrality toward you!\n",
				cname(who), who);
	} else if (rel == HOSTILE) {
		pr("Another cold war...\n");
		if((getrejects(who, getnatp(with)) & REJ_TELE) == 0)
		wu(0, with, "Country #%d has become hostile!\n", who);
#ifdef SLOW_WAR
	} else if ((rel == AT_WAR) || (rel == MOBILIZATION) || (rel ==SITZKRIEG)){
#else
	} else if (rel == AT_WAR) {
#endif /* SLOW_WAR */
#ifdef SLOW_WAR
		struct  natstr  *natp2;

		if ((oldrel >= rel) && (!player->god)){
			pr("No change required for that!\n");
			return RET_FAIL;
		}

		if (!player->god){
			natp2 = getnatp(with);
       			theirrel = getrel(natp2,who);
			switch (theirrel){
				case AT_WAR:	rel=AT_WAR ; break;
				case SITZKRIEG:	rel=SITZKRIEG ; break;
				case MOBILIZATION:rel=MOBILIZATION ; break;
				default:	if (natp->nat_money < War_Cost){
							pr("You don't have the money!\n");
							return RET_FAIL;
						}
						else{
							rel = MOBILIZATION;
							player->dolcost += War_Cost;
						}
			}
		}
#endif /* SLOW_WAR */
		pr("Declaration made (give 'em hell).\n");
		if((getrejects(who, getnatp(with)) & REJ_TELE) == 0)
		wu(0, with, "Country %s (#%d) has declared war on you!\n",
			cname(who), who);
		nreport(who, N_DECL_WAR, with, 1);
	}
#ifdef SLOW_WAR
	setrel(who,with,rel);
#endif /* SLOW_WAR */
	return RET_OK;
}
